package io.mangoo.enums;

/**
 * Default application values
 *
 * @author svenkubiak
 * @author williamdunne
 *
 */
public enum Default {
    APPLICATION_CONTROLLER("controllers."),
    APPLICATION_HEADERS_CONTENTSECURITYPOLICY(""),
    APPLICATION_HEADERS_REFERERPOLICY("no-referrer"),
    APPLICATION_HEADERS_SERVER("Undertow"),
    APPLICATION_HEADERS_XCONTENTTYPEOPTIONS("nosniff"),
    APPLICATION_HEADERS_XFRAMEOPTIONS("DENY"),
    APPLICATION_HEADERS_XSSPROTECTION("1"),
    APPLICATION_JWT_ENCRYPT(Constants.FALSE),
    APPLICATION_SECRET_MIN_LENGTH("32"),
    APPLICATION_TEST_MASTERKEY("f8%q8G6Px8vxn7Tl%2P40vyT9e8KeTJ9"),
    ASSETS_PATH("src/main/resources/files/assets/"),
    
    @Deprecated /** Use AUTHENTICATION_COOKIE_ENCRYPT instead **/
    AUTH_COOKIE_ENCRYPT(Constants.FALSE),
    
    @Deprecated /** Use AUTHENTICATION_COOKIE_EXPIRES instead **/
    AUTH_COOKIE_EXPIRES("3600"),
    
    @Deprecated /** Use AUTHENTICATION_COOKIE_NAME instead **/
    AUTH_COOKIE_NAME("MANGOOIO-AUTH"),
    
    @Deprecated /** Use AUTHENTICATION_COOKIE_REMEMBER_EXPIRES instead **/
    AUTH_COOKIE_REMEMBER_EXPIRES("1209600"),
    
    @Deprecated /** Use AUTHENTICATION_COOKIE_SECURE instead **/
    AUTH_COOKIE_SECURE(Constants.FALSE),
    
    @Deprecated /** Use AUTHENTICATION_COOKIE_VERSION instead **/
    AUTH_COOKIE_VERSION("0"),
    
    @Deprecated /** Use AUTHENTICATION_LOCK instead **/
    AUTH_LOCK("10"),
 
    AUTHENTICATION_COOKIE_ENCRYPT(Constants.FALSE),
    AUTHENTICATION_COOKIE_EXPIRES("3600"),
    AUTHENTICATION_COOKIE_NAME("MANGOOIO-AUTH"),
    AUTHENTICATION_COOKIE_REMEMBER_EXPIRES("1209600"),
    AUTHENTICATION_COOKIE_SECURE(Constants.FALSE),
    AUTHENTICATION_COOKIE_VERSION("0"),
    AUTHENTICATION_LOCK("10"),
    AUTHENTICITY("authenticity"),
    BASICAUTH_CREDENTIALS_LENGTH("2"),
    BUNDLE_NAME("translations/messages"),
    CACHE_CLUSTER_ENABLE(Constants.FALSE),
    CONFIG_PATH("/src/main/resources/application.yaml"),
    CONFIGURATION_FILE("application.yaml"),
    CONTENT_TYPE("text/html; charset=UTF-8"),
    
    @Deprecated /** Use SESSION_COOKIE_ENCRYPTION instead **/
    COOKIE_ENCRYPTION(Constants.FALSE),
    
    @Deprecated /** Use SESSION_COOKIE_EXPIRES instead **/
    COOKIE_EXPIRES("86400"),
    
    @Deprecated /** Use SESSION_COOKIE_NAME instead **/
    COOKIE_NAME("MANGOOIO-SESSION"),
    
    @Deprecated /** Use SESSION_COOKIE_SECURE instead **/
    COOKIE_SECURE(Constants.FALSE),
    
    @Deprecated /** Use SESSION_COOKIE_VERSION instead **/
    COOKIE_VERSION("0"),
    
    I18N_COOKIE_NAME("MANGOOIO-I18N"),
    SESSION_COOKIE_ENCRYPTION(Constants.FALSE),
    SESSION_COOKIE_EXPIRES("86400"),
    SESSION_COOKIE_NAME("MANGOOIO-SESSION"),
    SESSION_COOKIE_SECURE(Constants.FALSE),
    SESSION_COOKIE_VERSION("0"),
    DATA_DELIMITER("#"),
    DEFAULT_CONFIGURATION("default"),
    DEFAULT_TEMPLATES_DIR("/templates/defaults/"), //NOSONAR
    DELIMITER("|"), //NOSONAR
    ENCODING("UTF-8"),
    EXECUTION_THREADPOOL("10"),
    FILES_FOLDER("files"),
    FILES_PATH("src/main/resources/files/"),
    FILTER_METHOD("execute"),
    FLASH_COOKIE_NAME("MANGOOIO-FLASH"),
    JAVASCRIPT_FOLDER("javascript"),
    JBCRYPT_ROUNDS("12"),
    LANGUAGE("en"),
    LIFECYCLE_CLASS("conf.Lifecycle"),
    LOGO_FILE("logo.txt"),
    METRICS_ENABLE(Constants.FALSE),
    MODULE_CLASS("conf.Module"),
    NUMBER_FORMAT("0.######"),
    OAUTH_REQUEST_PARAMETER("oauth"),
    ROUTES_FILE("routes.yaml"),
    SCHEDULER_AUTOSTART("true"),
    SCHEDULER_JOB_GROUP("MangooSchedulerJobGroup"),
    SCHEDULER_PACKAGE("jobs"),
    SCHEDULER_PREFIX("org.quartz."),
    SCHEDULER_TRIGGER_GROUP("MangooSchedulerTriggerGroup"),
    SMTP_FROM("mangoo I/O application <noreply@example.com>"),
    SMTP_HOST("localhost"),
    SMTP_PORT("25"),
    SMTP_SERVER_NAME("smtp"),
    SMTP_SSL(Constants.FALSE),
    SSE_CACHE_PREFIX("MANGOOIO-SSE-"),
    STYLESHEET_FOLDER("stylesheet"),
    TEMPLATE_ENGINE_CLASS("io.mangoo.templating.TemplateEngineFreemarker"),
    TEMPLATES_FOLDER("/templates/"),
    UNDERTOW_MAX_ENTITY_SIZE("4194304"),
    VERSION("unknown"),
    VERSION_PROPERTIES("version.properties"),
    WSS_CACHE_PREFIX("MANGOOIO-WSS-");

    private static class Constants {
        public static final String FALSE = "false";
        
        private Constants() {
        }
    }
    
    private final String value;

    Default (String value) {
        this.value = value;
    }

    public boolean toBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    public int toInt() {
        return Integer.parseInt(this.value);
    }

    public long toLong() {
        return Long.parseLong(this.value);
    }
    
    @Override
    public String toString() {
        return this.value;
    }
}