/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import com.google.inject.Inject;
import com.google.re2j.Pattern;
import dev.paseto.jpaseto.PasetoV1LocalBuilder;
import dev.paseto.jpaseto.Pasetos;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.admin.AdminFilter;
import io.mangoo.annotations.FilterWith;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.crypto.Crypto;
import io.mangoo.enums.CacheName;
import io.mangoo.enums.Default;
import io.mangoo.enums.HmacShaAlgorithm;
import io.mangoo.enums.Key;
import io.mangoo.enums.Required;
import io.mangoo.enums.Template;
import io.mangoo.exceptions.MangooEncryptionException;
import io.mangoo.exceptions.MangooSchedulerException;
import io.mangoo.models.Metrics;
import io.mangoo.routing.Response;
import io.mangoo.routing.Router;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Request;
import io.mangoo.scheduler.Scheduler;
import io.mangoo.services.EventBusService;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.TotpUtils;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class AdminController {
    private static final Logger LOG = LogManager.getLogger(AdminController.class);
    private static final String ENABLED = "enabled";
    private static final String ADMIN_INDEX = "/@admin";
    private static final Pattern PATTERN = Pattern.compile((String)"[^a-zA-Z0-9]");
    private static final String MANGOOIO_ADMIN_LOCK_COUNT = "mangooio-admin-lock-count";
    private static final String MANGOOIO_ADMIN_LOCKED_UNTIL = "mangooio-admin-locked-until";
    private static final String PERIOD = "30";
    private static final String DIGITS = "6";
    private static final String URL = "url";
    private static final String METHOD = "method";
    private static final String CACHE_ADMINROUTES = "cache_adminroutes";
    private static final String JOBS = "jobs";
    private static final String LOGGER = "logger";
    private static final String METRICS = "metrics";
    private static final String ROUTES = "routes";
    private static final String SPACE = "space";
    private static final String TOOLS = "tools";
    private static final String VERSION = "version";
    private static final String VERSION_TAG = MangooUtils.getVersion();
    private static final double HUNDRED_PERCENT = 100.0;
    private static final int ADMIN_LOGIN_MAX_RETRIES = 10;
    private final Cache cache;
    private final Config config;
    private final Crypto crypto;
    private final Scheduler scheduler;

    @Inject
    public AdminController(Scheduler scheduler, Crypto crypto, Config config, CacheProvider cacheProvider) {
        this.config = Objects.requireNonNull(config, Required.CONFIG.toString());
        this.scheduler = Objects.requireNonNull(scheduler, Required.SCHEDULER.toString());
        this.crypto = Objects.requireNonNull(crypto, Required.CRYPTO.toString());
        this.cache = cacheProvider.getCache(CacheName.APPLICATION);
    }

    @FilterWith(value={AdminFilter.class})
    public Response execute(String string) {
        try {
            this.scheduler.executeJob(string);
        }
        catch (MangooSchedulerException mangooSchedulerException) {
            LOG.error("Failed to execute job with name: " + string, (Throwable)mangooSchedulerException);
        }
        return Response.withRedirect("/@admin/scheduler");
    }

    @FilterWith(value={AdminFilter.class})
    public Response index() {
        Instant instant = Application.getStart().atZone(ZoneId.systemDefault()).toInstant();
        boolean bl = this.config.isMetricsEnable();
        if (bl) {
            Metrics metrics = Application.getInstance(Metrics.class);
            long l = 0L;
            long l2 = 0L;
            for (Map.Entry<Integer, LongAdder> entry : metrics.getResponseMetrics().entrySet()) {
                if (String.valueOf(entry.getKey()).charAt(0) == '5') {
                    l2 += entry.getValue().longValue();
                }
                l += entry.getValue().longValue();
            }
            double d = 0.0;
            if (l2 > 0L) {
                d = 100.0 / (double)l * (double)l2;
            }
            EventBusService eventBusService = Application.getInstance(EventBusService.class);
            return Response.withOk().andContent(VERSION, MangooUtils.getVersion()).andContent(SPACE, null).andContent(ENABLED, bl).andContent("uptime", Date.from(instant)).andContent("warnings", this.cache.get(Key.MANGOOIO_WARNINGS.toString())).andContent(METRICS, metrics.getResponseMetrics()).andContent("dataSend", MangooUtils.readableFileSize(metrics.getDataSend())).andContent("totalRequests", l).andContent("minRequestTime", metrics.getMinRequestTime()).andContent("avgRequestTime", metrics.getAvgRequestTime()).andContent("maxRequestTime", metrics.getMaxRequestTime()).andContent("errorRate", d).andContent("events", eventBusService.getNumEvents()).andContent("listeners", eventBusService.getNumListeners()).andContent(ENABLED, bl).andTemplate(Template.DEFAULT.adminPath());
        }
        return Response.withOk().andContent(VERSION, MangooUtils.getVersion()).andContent(SPACE, null).andContent(ENABLED, bl).andContent("uptime", Date.from(instant)).andContent("warnings", this.cache.get(Key.MANGOOIO_WARNINGS.toString())).andTemplate(Template.DEFAULT.adminPath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response logger() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        return Response.withOk().andContent(SPACE, LOGGER).andContent(VERSION, VERSION_TAG).andContent("loggers", loggerContext.getLoggers()).andTemplate(Template.DEFAULT.loggerPath());
    }

    public Response login() {
        return Response.withOk().andTemplate(Template.DEFAULT.loginPath());
    }

    public Response logout() {
        Cookie cookie = new CookieImpl(Default.ADMIN_COOKIE_NAME.toString()).setValue("").setHttpOnly(true).setSecure(Application.inProdMode()).setPath("/").setDiscard(true).setExpires(new Date()).setSameSite(true).setSameSiteMode("Strict");
        return Response.withRedirect(ADMIN_INDEX).andCookie(cookie);
    }

    public Response authenticate(Form form) {
        form.expectValue("username");
        form.expectValue("password");
        if (this.isNotLocked() && form.isValid()) {
            if (this.isValidAuthentication(form)) {
                this.cache.resetCounter(MANGOOIO_ADMIN_LOCK_COUNT);
                return Response.withRedirect(ADMIN_INDEX).andCookie(this.getAdminCookie(true));
            }
            this.invalidAuthentication();
        }
        form.invalidate();
        form.keep();
        return Response.withRedirect("/@admin/login");
    }

    public Response verify(Form form) {
        form.expectValue("code");
        if (this.isNotLocked() && form.isValid()) {
            if (TotpUtils.verifiedTotp(this.config.getApplicationAdminSecret(), form.get("code"))) {
                return Response.withRedirect(ADMIN_INDEX).andCookie(this.getAdminCookie(false));
            }
            this.invalidAuthentication();
        }
        form.invalidate();
        form.keep();
        return Response.withRedirect("/@admin/twofactor");
    }

    public Response twofactor() {
        return Response.withOk().andTemplate(Template.DEFAULT.twofactorPath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response loggerajax(Request request) {
        Map<String, Object> map = request.getBodyAsJsonMap();
        if (map != null && map.size() > 0) {
            String string = map.get("class").toString();
            String string2 = map.get("level").toString();
            if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2)) {
                LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                loggerContext.getLoggers().stream().filter(logger -> string.equals(logger.getName())).forEach(logger -> logger.setLevel(Level.getLevel((String)string2)));
            }
        }
        return Response.withOk().andEmptyBody();
    }

    @FilterWith(value={AdminFilter.class})
    @SuppressFBWarnings(value={"CE_CLASS_ENVY"}, justification="JSONObject creation as intended")
    public Response routes() {
        List<JSONObject> list = this.getRoutes();
        if (list.isEmpty()) {
            Router.getFileRoutes().forEach(fileRoute -> {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)METHOD, (Object)"FILE");
                jSONObject.put((Object)URL, (Object)fileRoute.getUrl());
                list.add(jSONObject);
            });
            Router.getPathRoutes().forEach(pathRoute -> {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)METHOD, (Object)"PATH");
                jSONObject.put((Object)URL, (Object)pathRoute.getUrl());
                list.add(jSONObject);
            });
            Router.getServerSentEventRoutes().forEach(serverSentEventRoute -> {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)METHOD, (Object)"SSE");
                jSONObject.put((Object)URL, (Object)serverSentEventRoute.getUrl());
                list.add(jSONObject);
            });
            Router.getWebSocketRoutes().forEach(webSocketRoute -> {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)METHOD, (Object)"WSS");
                jSONObject.put((Object)URL, (Object)webSocketRoute.getUrl());
                jSONObject.put((Object)"controllerClass", webSocketRoute.getControllerClass());
                list.add(jSONObject);
            });
            Router.getRequestRoutes().filter(requestRoute -> !requestRoute.getUrl().contains("@admin")).forEach(requestRoute -> {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put((Object)METHOD, (Object)requestRoute.getMethod());
                jSONObject.put((Object)URL, (Object)requestRoute.getUrl());
                jSONObject.put((Object)"controllerClass", requestRoute.getControllerClass());
                jSONObject.put((Object)"controllerMethod", (Object)requestRoute.getControllerMethod());
                jSONObject.put((Object)"limit", (Object)requestRoute.getLimit());
                jSONObject.put((Object)"basicAuthentication", (Object)requestRoute.hasBasicAuthentication());
                jSONObject.put((Object)"authentication", (Object)requestRoute.hasAuthentication());
                jSONObject.put((Object)"authorization", (Object)requestRoute.hasAuthorization());
                jSONObject.put((Object)"blocking", (Object)requestRoute.isBlocking());
                list.add(jSONObject);
            });
            this.cache.put(CACHE_ADMINROUTES, list);
        }
        return Response.withOk().andContent(SPACE, ROUTES).andContent(VERSION, VERSION_TAG).andContent(ROUTES, list).andTemplate(Template.DEFAULT.routesPath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response scheduler() {
        List<Object> list = new ArrayList();
        if (this.scheduler.isInitialize()) {
            try {
                list = this.scheduler.getAllJobs();
            }
            catch (MangooSchedulerException mangooSchedulerException) {
                LOG.error("Failed to retrieve jobs from scheduler", (Throwable)mangooSchedulerException);
            }
        }
        return Response.withOk().andContent(SPACE, "scheduler").andContent(VERSION, VERSION_TAG).andContent(JOBS, list).andTemplate(Template.DEFAULT.schedulerPath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response state(String string) {
        try {
            this.scheduler.changeState(string);
        }
        catch (MangooSchedulerException mangooSchedulerException) {
            LOG.error("Failed to change the state of job with name: " + string, (Throwable)mangooSchedulerException);
        }
        return Response.withRedirect("/@admin/scheduler");
    }

    @FilterWith(value={AdminFilter.class})
    public Response tools() {
        String string = this.config.getApplicationAdminSecret();
        String string2 = null;
        if (StringUtils.isBlank((CharSequence)string)) {
            string = TotpUtils.createSecret();
            string2 = TotpUtils.getQRCode("mangoo_IO_Admin", PATTERN.matcher((CharSequence)this.config.getApplicationName()).replaceAll(""), string, HmacShaAlgorithm.HMAC_SHA_512, DIGITS, PERIOD);
        }
        return Response.withOk().andContent("qrcode", string2).andContent("secret", string).andContent(SPACE, TOOLS).andContent(VERSION, VERSION_TAG).andTemplate(Template.DEFAULT.toolsPath());
    }

    @FilterWith(value={AdminFilter.class})
    public Response toolsajax(Request request) {
        Map<String, Object> map = request.getBodyAsJsonMap();
        Object object = "";
        if (map != null && map.size() > 0) {
            String string = map.get("function").toString();
            if ("keypair".equalsIgnoreCase(string)) {
                KeyPair keyPair = this.crypto.generateKeyPair();
                String string2 = this.crypto.getKeyAsString(keyPair.getPublic());
                String string3 = this.crypto.getKeyAsString(keyPair.getPrivate());
                object = "{\"publickey\" : \"" + string2 + "\", \"privatekey\" : \"" + string3 + "\"}";
            } else if ("encrypt".equalsIgnoreCase(string)) {
                String string4 = map.get("cleartext").toString();
                String string5 = map.get("key").toString();
                try {
                    PublicKey publicKey = this.crypto.getPublicKeyFromString(string5);
                    object = this.crypto.encrypt(string4, publicKey);
                }
                catch (MangooEncryptionException mangooEncryptionException) {
                    LOG.error("Failed to encrypt cleartext.", (Throwable)mangooEncryptionException);
                }
            } else {
                LOG.warn("Invalid or no function selected for AJAX request.");
            }
        }
        return Response.withOk().andJsonBody(object);
    }

    private List<JSONObject> getRoutes() {
        List list = (List)this.cache.get(CACHE_ADMINROUTES);
        return list == null ? new ArrayList() : list;
    }

    private boolean isValidAuthentication(Form form) {
        String string;
        boolean bl = false;
        String string2 = this.config.getApplicationAdminUsername();
        if (this.checkAuthentication(form, string2, string = this.config.getApplicationAdminPassword())) {
            bl = true;
        }
        return bl;
    }

    private boolean checkAuthentication(Form form, String string, String string2) {
        return StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2) && string.equals(form.get("username")) && string2.equals(form.get("password"));
    }

    private Cookie getAdminCookie(boolean bl) {
        PasetoV1LocalBuilder pasetoV1LocalBuilder = (PasetoV1LocalBuilder)((PasetoV1LocalBuilder)Pasetos.V1.LOCAL.builder().setSharedSecret((SecretKey)new SecretKeySpec(this.config.getApplicationSecret().getBytes(StandardCharsets.UTF_8), "AES")).setExpiration(LocalDateTime.now().plusMinutes(30L).toInstant(ZoneOffset.UTC))).claim("uuid", (Object)MangooUtils.randomString(32));
        if (bl && StringUtils.isNotBlank((CharSequence)this.config.getApplicationAdminSecret())) {
            pasetoV1LocalBuilder.claim("twofactor", (Object)Boolean.TRUE);
        }
        return new CookieImpl(Default.ADMIN_COOKIE_NAME.toString()).setValue(pasetoV1LocalBuilder.compact()).setHttpOnly(true).setSecure(Application.inProdMode()).setPath("/").setSameSite(true).setSameSiteMode("Strict");
    }

    private void invalidAuthentication() {
        AtomicInteger atomicInteger = this.cache.getAndIncrementCounter(MANGOOIO_ADMIN_LOCK_COUNT);
        if (atomicInteger.intValue() >= 10) {
            this.cache.put(MANGOOIO_ADMIN_LOCKED_UNTIL, LocalDateTime.now().plusMinutes(60L));
        }
        this.cache.put(MANGOOIO_ADMIN_LOCK_COUNT, atomicInteger);
    }

    private boolean isNotLocked() {
        LocalDateTime localDateTime = (LocalDateTime)this.cache.get(MANGOOIO_ADMIN_LOCKED_UNTIL);
        return localDateTime == null || localDateTime.isBefore(LocalDateTime.now());
    }
}

