/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.cache;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheImpl;
import io.mangoo.core.Config;
import io.mangoo.enums.CacheName;
import io.mangoo.enums.Required;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.ehcache.CacheManager;
import org.ehcache.clustered.client.config.builders.ClusteringServiceConfigurationBuilder;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;

@Singleton
public class CacheProvider
implements Provider<Cache> {
    private Map<String, Cache> caches = new HashMap<String, Cache>();
    private CacheManager cacheManager;
    private Cache cache;
    private static final long SIXTY = 60L;
    private static final long THIRTY = 30L;
    private static final long FORTY_THOUSAND_ELEMENTS = 40000L;
    private static final long TWENTY_THOUSAND_ELEMENTS = 20000L;

    @Inject
    @SuppressFBWarnings(value={"FII_USE_FUNCTION_IDENTITY"}, justification="Required by cache creation function")
    public CacheProvider(Config config) {
        Objects.requireNonNull(config, Required.CONFIG.toString());
        if (config.isCacheCluserEnable()) {
            CacheManagerBuilder cacheManagerBuilder = CacheManagerBuilder.newCacheManagerBuilder().with((Builder)ClusteringServiceConfigurationBuilder.cluster((URI)URI.create(config.getCacheClusterUrl())).autoCreate(serverSideConfigurationBuilder -> serverSideConfigurationBuilder));
            this.cacheManager = cacheManagerBuilder.build(true);
        } else {
            this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().build();
            this.cacheManager.init();
        }
        this.initApplicationCache();
        this.initAuthenticationCache();
        this.initRequestCache();
        this.initResponseCache();
        this.initServerEventCache();
        this.initWebSocketCache();
    }

    private final void initApplicationCache() {
        CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)20000L)).build();
        this.cache = this.registerCacheConfiguration(CacheName.APPLICATION.toString(), (CacheConfiguration<String, Object>)cacheConfiguration);
    }

    private final void initAuthenticationCache() {
        CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)20000L)).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.of(60L, ChronoUnit.MINUTES))).build();
        this.registerCacheConfiguration(CacheName.AUTH.toString(), (CacheConfiguration<String, Object>)cacheConfiguration);
    }

    private final void initRequestCache() {
        CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)40000L)).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.of(60L, ChronoUnit.SECONDS))).build();
        this.registerCacheConfiguration(CacheName.REQUEST.toString(), (CacheConfiguration<String, Object>)cacheConfiguration);
    }

    private final void initResponseCache() {
        CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)20000L)).build();
        this.registerCacheConfiguration(CacheName.RESPONSE.toString(), (CacheConfiguration<String, Object>)cacheConfiguration);
    }

    private final void initServerEventCache() {
        CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)20000L)).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.of(30L, ChronoUnit.MINUTES))).build();
        this.registerCacheConfiguration(CacheName.SSE.toString(), (CacheConfiguration<String, Object>)cacheConfiguration);
    }

    private final void initWebSocketCache() {
        CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)20000L)).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.of(30L, ChronoUnit.MINUTES))).build();
        this.registerCacheConfiguration(CacheName.WSS.toString(), (CacheConfiguration<String, Object>)cacheConfiguration);
    }

    public Cache registerCacheConfiguration(String string, CacheConfiguration<String, Object> cacheConfiguration) {
        this.cache = new CacheImpl((org.ehcache.Cache<String, Object>)this.cacheManager.createCache(string, cacheConfiguration));
        this.caches.put(string, this.cache);
        return this.cache;
    }

    public Cache get() {
        return this.cache;
    }

    public Cache getCache(CacheName cacheName) {
        return this.getCache(cacheName.toString());
    }

    public Cache getCache(String string) {
        return this.caches.get(string);
    }

    public void close() {
        this.cacheManager.close();
    }
}

