/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.common.io.Resources;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Stage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ClassGraph;
import io.mangoo.admin.AdminController;
import io.mangoo.annotations.Schedule;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Config;
import io.mangoo.core.Module;
import io.mangoo.core.Shutdown;
import io.mangoo.enums.CacheName;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.Mode;
import io.mangoo.enums.Required;
import io.mangoo.exceptions.MangooSchedulerException;
import io.mangoo.interfaces.MangooBootstrap;
import io.mangoo.routing.Bind;
import io.mangoo.routing.On;
import io.mangoo.routing.Router;
import io.mangoo.routing.handlers.DispatcherHandler;
import io.mangoo.routing.handlers.ExceptionHandler;
import io.mangoo.routing.handlers.FallbackHandler;
import io.mangoo.routing.handlers.MetricsHandler;
import io.mangoo.routing.handlers.ServerSentEventHandler;
import io.mangoo.routing.handlers.WebSocketHandler;
import io.mangoo.scheduler.Scheduler;
import io.mangoo.utils.ByteUtils;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.SchedulerUtils;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.util.Methods;
import io.undertow.websockets.WebSocketConnectionCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public final class Application {
    private static final Logger LOG = LogManager.getLogger(Application.class);
    private static final int KEY_MIN_BIT_LENGTH = 512;
    private static final int BUFFERSIZE = 255;
    private static String httpHost;
    private static String ajpHost;
    private static Undertow undertow;
    private static Mode mode;
    private static Injector injector;
    private static LocalDateTime start;
    private static PathHandler pathHandler;
    private static boolean started;
    private static int httpPort;
    private static int ajpPort;

    private Application() {
    }

    public static void main(String ... stringArray) {
        Application.start(Mode.PROD);
    }

    public static void start(Mode mode) {
        Objects.requireNonNull(mode, Required.MODE.toString());
        if (!started) {
            Application.userCheck();
            Application.prepareMode(mode);
            Application.prepareInjector();
            Application.applicationInitialized();
            Application.prepareConfig();
            Application.prepareRoutes();
            Application.createRoutes();
            Application.prepareScheduler();
            Application.prepareUndertow();
            Application.sanityChecks();
            Application.showLogo();
            Application.applicationStarted();
            Runtime.getRuntime().addShutdownHook(Application.getInstance(Shutdown.class));
            started = true;
        }
    }

    private static void userCheck() {
        String string = System.getProperty("os.name");
        if (StringUtils.isNotBlank((CharSequence)string) && !string.startsWith("Windows")) {
            try {
                Process process = Runtime.getRuntime().exec("id -u");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
                String string2 = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
                bufferedReader.close();
                if ("0".equals(string2) && Application.inProdMode()) {
                    LOG.error("Can not run application as root");
                    Application.failsafe();
                }
            }
            catch (IOException iOException) {
                LOG.error("Failed to check user running application", (Throwable)iOException);
            }
        }
    }

    public static boolean inDevMode() {
        return Mode.DEV == mode;
    }

    public static boolean inProdMode() {
        return Mode.PROD == mode;
    }

    public static boolean inTestMode() {
        return Mode.TEST == mode;
    }

    public static Mode getMode() {
        return mode;
    }

    public static Injector getInjector() {
        return injector;
    }

    public static boolean isStarted() {
        return started;
    }

    public static LocalDateTime getStart() {
        return start;
    }

    public static Duration getUptime() {
        Objects.requireNonNull(start, Required.START.toString());
        return Duration.between(start, LocalDateTime.now());
    }

    public static <T> T getInstance(Class<T> clazz) {
        Objects.requireNonNull(clazz, Required.CLASS.toString());
        return (T)injector.getInstance(clazz);
    }

    public static void stopUndertow() {
        undertow.stop();
    }

    private static void prepareMode(Mode mode) {
        String string = System.getProperty(Key.APPLICATION_MODE.toString());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            switch (string.toLowerCase(Locale.ENGLISH)) {
                case "dev": {
                    Application.mode = Mode.DEV;
                    break;
                }
                case "test": {
                    Application.mode = Mode.TEST;
                    break;
                }
                default: {
                    Application.mode = Mode.PROD;
                    break;
                }
            }
        } else {
            Application.mode = mode;
        }
    }

    private static void prepareInjector() {
        injector = Guice.createInjector((Stage)Stage.PRODUCTION, Application.getModules());
    }

    private static void applicationInitialized() {
        Application.getInstance(MangooBootstrap.class).applicationInitialized();
    }

    private static void prepareConfig() {
        Config config = Application.getInstance(Config.class);
        int n = Application.getBitLength(config.getApplicationSecret());
        if (n < 512) {
            LOG.error("Application requires a 512 bit application secret. The current property for application.secret has currently only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getAuthenticationCookieSecret())) < 512) {
            LOG.error("Authentication cookie requires a 512 bit encryption key. The current property for authentication.cookie.secret has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getAuthenticationCookieSecret())) < 512) {
            LOG.error("Authentication cookie requires a 512 bit sign key. The current property for authentication.cookie.signkey has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getSessionCookieSecret())) < 512) {
            LOG.error("Session cookie secret a 512 bit encryption key. The current property for session.cookie.secret has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getSessionCookieSecret())) < 512) {
            LOG.error("Session cookie requires a 512 bit sign key. The current property for session.cookie.signkey has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getFlashCookieSecret())) < 512) {
            LOG.error("Flash cookie requires a 512 bit sign key. The current property for flash.cookie.signkey has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if ((n = Application.getBitLength(config.getFlashCookieSecret())) < 512) {
            LOG.error("Flash cookie requires a 512 bit encryption key. The current property for flash.cookie.secret has only {} bit.", (Object)n);
            Application.failsafe();
        }
        if (!config.isDecrypted()) {
            LOG.error("Found encrypted config values in config.props but decryption was not successful!");
            Application.failsafe();
        }
    }

    private static void sanityChecks() {
        String string;
        Config config = Application.getInstance(Config.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!config.isAuthenticationCookieSecure()) {
            string = "Authentication cookie has secure flag set to 'false'. It is highly recommended to set authentication.cookie.secure to 'true' in an production environment.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getAuthenticationCookieName().equals(Default.AUTHENTICATION_COOKIE_NAME.toString())) {
            string = "Authentication cookie name has default value. Consider changing authentication.cookie.name to an application specific value.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getAuthenticationCookieSecret().equals(config.getApplicationSecret())) {
            string = "Authentication cookie secret is using application secret. It is highly recommended to set a dedicated value to authentication.cookie.secret.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (!config.isSessionCookieSecure()) {
            string = "Session cookie has secure flag set to 'false'. It is highly recommended to set session.cookie.secure to 'true' in an production environment.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getSessionCookieName().equals(Default.SESSION_COOKIE_NAME.toString())) {
            string = "Session cookie name has default value. Consider changing session.cookie.name to an application specific value.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getSessionCookieSecret().equals(config.getApplicationSecret())) {
            string = "Session cookie secret is using application secret. It is highly recommended to set a dedicated value to session.cookie.secret.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getFlashCookieName().equals(Default.FLASH_COOKIE_NAME.toString())) {
            string = "Flash cookie name has default value. Consider changing flash.cookie.name to an application specific value.";
            arrayList.add(string);
            LOG.warn(string);
        }
        if (config.getFlashCookieSecret().equals(config.getApplicationSecret())) {
            string = "Flash cookie secret is using application secret. It is highly recommended to set a dedicated value to flash.cookie.secret.";
            arrayList.add(string);
            LOG.warn(string);
        }
        Application.getInstance(CacheProvider.class).getCache(CacheName.APPLICATION).put(Key.MANGOOIO_WARNINGS.toString(), arrayList);
    }

    private static void prepareRoutes() {
        ((MangooBootstrap)injector.getInstance(MangooBootstrap.class)).initializeRoutes();
        Router.getRequestRoutes().forEach(requestRoute -> {
            if (!Application.methodExists(requestRoute.getControllerMethod(), requestRoute.getControllerClass())) {
                LOG.error("Could not find controller method '{}' in controller class '{}'", (Object)requestRoute.getControllerMethod(), requestRoute.getControllerClass());
                Application.failsafe();
            }
            if (!(!requestRoute.hasAuthorization() || MangooUtils.resourceExists(Default.MODEL_CONF.toString()) && MangooUtils.resourceExists(Default.POLICY_CSV.toString()))) {
                LOG.error("Route on method '{}' in controller class '{}' requires authorization, but either model.conf or policy.csv is missing", (Object)requestRoute.getControllerMethod(), requestRoute.getControllerClass());
                Application.failsafe();
            }
        });
    }

    private static boolean methodExists(String string, Class<?> clazz) {
        Objects.requireNonNull(string, Required.CONTROLLER_METHOD.toString());
        Objects.requireNonNull(clazz, Required.CONTROLLER_CLASS.toString());
        return Arrays.stream(clazz.getMethods()).anyMatch(method -> method.getName().equals(string));
    }

    private static void createRoutes() {
        pathHandler = new PathHandler((HttpHandler)Application.getRoutingHandler());
        Router.getWebSocketRoutes().forEach(webSocketRoute -> pathHandler.addExactPath(webSocketRoute.getUrl(), (HttpHandler)Handlers.websocket((WebSocketConnectionCallback)Application.getInstance(WebSocketHandler.class).withControllerClass(webSocketRoute.getControllerClass()).withAuthentication(webSocketRoute.hasAuthentication()))));
        Router.getServerSentEventRoutes().forEach(serverSentEventRoute -> pathHandler.addExactPath(serverSentEventRoute.getUrl(), (HttpHandler)Handlers.serverSentEvents((ServerSentEventConnectionCallback)Application.getInstance(ServerSentEventHandler.class).withAuthentication(serverSentEventRoute.hasAuthentication()))));
        Router.getPathRoutes().forEach(pathRoute -> pathHandler.addPrefixPath(pathRoute.getUrl(), (HttpHandler)new ResourceHandler((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), Default.FILES_FOLDER.toString() + pathRoute.getUrl()))));
        Config config = Application.getInstance(Config.class);
        if (config.isApplicationAdminEnable()) {
            pathHandler.addPrefixPath("/@admin/assets/", (HttpHandler)new ResourceHandler((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), "templates/@admin/assets/")));
        }
    }

    private static RoutingHandler getRoutingHandler() {
        RoutingHandler routingHandler = Handlers.routing();
        routingHandler.setFallbackHandler((HttpHandler)Application.getInstance(FallbackHandler.class));
        Config config = Application.getInstance(Config.class);
        if (config.isApplicationAdminEnable()) {
            Bind.controller(AdminController.class).withRoutes(On.get().to("/@admin").respondeWith("index"), On.get().to("/@admin/login").respondeWith("login"), On.get().to("/@admin/twofactor").respondeWith("twofactor"), On.get().to("/@admin/scheduler").respondeWith("scheduler"), On.get().to("/@admin/logger").respondeWith("logger"), On.get().to("/@admin/routes").respondeWith("routes"), On.get().to("/@admin/tools").respondeWith("tools"), On.get().to("/@admin/scheduler/execute/{name}").respondeWith("execute"), On.get().to("/@admin/scheduler/state/{name}").respondeWith("state"), On.get().to("/@admin/logout").respondeWith("logout"), On.post().to("/@admin/authenticate").respondeWith("authenticate"), On.post().to("/@admin/verify").respondeWith("verify"), On.post().to("/@admin/logger/ajax").respondeWith("loggerajax"), On.post().to("/@admin/tools/ajax").respondeWith("toolsajax"));
        }
        Router.getRequestRoutes().forEach(requestRoute -> {
            DispatcherHandler dispatcherHandler = Application.getInstance(DispatcherHandler.class).dispatch(requestRoute.getControllerClass(), requestRoute.getControllerMethod()).isBlocking(requestRoute.isBlocking()).withBasicAuthentication(requestRoute.getUsername(), requestRoute.getPassword()).withAuthentication(requestRoute.hasAuthentication()).withAuthorization(requestRoute.hasAuthorization()).withLimit(requestRoute.getLimit());
            routingHandler.add(requestRoute.getMethod().toString(), requestRoute.getUrl(), (HttpHandler)dispatcherHandler);
        });
        ResourceHandler resourceHandler = Handlers.resource((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), Default.FILES_FOLDER.toString() + "/"));
        Router.getFileRoutes().forEach(fileRoute -> routingHandler.add(Methods.GET, fileRoute.getUrl(), (HttpHandler)resourceHandler));
        return routingHandler;
    }

    private static void prepareUndertow() {
        Config config = Application.getInstance(Config.class);
        Object object = config.isMetricsEnable() ? MetricsHandler.HANDLER_WRAPPER.wrap((HttpHandler)Handlers.exceptionHandler((HttpHandler)pathHandler).addExceptionHandler(Throwable.class, (HttpHandler)Application.getInstance(ExceptionHandler.class))) : Handlers.exceptionHandler((HttpHandler)pathHandler).addExceptionHandler(Throwable.class, (HttpHandler)Application.getInstance(ExceptionHandler.class));
        Undertow.Builder builder = Undertow.builder().setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)config.getUndertowMaxEntitySize()).setHandler((HttpHandler)object);
        httpHost = config.getConnectorHttpHost();
        httpPort = config.getConnectorHttpPort();
        ajpHost = config.getConnectorAjpHost();
        ajpPort = config.getConnectorAjpPort();
        boolean bl = false;
        if (httpPort > 0 && StringUtils.isNotBlank((CharSequence)httpHost)) {
            builder.addHttpListener(httpPort, httpHost);
            bl = true;
        }
        if (ajpPort > 0 && StringUtils.isNotBlank((CharSequence)ajpHost)) {
            builder.addAjpListener(ajpPort, ajpHost);
            bl = true;
        }
        if (bl) {
            undertow = builder.build();
            undertow.start();
        } else {
            LOG.error("No connector found! Please configure a HTTP and/or AJP connector in your config.props");
            Application.failsafe();
        }
    }

    @SuppressFBWarnings(justification="Buffer only used locally, without user input", value={"CRLF_INJECTION_LOGS"})
    private static void showLogo() {
        StringBuilder stringBuilder = new StringBuilder(255);
        stringBuilder.append('\n').append(Application.getLogo()).append("\n\nhttps://github.com/svenkubiak/mangooio | @mangoo_io | ").append(MangooUtils.getVersion()).append('\n');
        String string = stringBuilder.toString();
        LOG.info(string);
        if (httpPort > 0 && StringUtils.isNotBlank((CharSequence)httpHost)) {
            LOG.info("HTTP connector listening @{}:{}", (Object)httpHost, (Object)httpPort);
        }
        if (ajpPort > 0 && StringUtils.isNotBlank((CharSequence)ajpHost)) {
            LOG.info("AJP connector listening @{}:{}", (Object)ajpHost, (Object)ajpPort);
        }
        String string2 = "mangoo I/O application started in " + ChronoUnit.MILLIS.between(start, LocalDateTime.now()) + " ms in " + mode.toString() + " mode. Enjoy.";
        LOG.info(string2);
    }

    @SuppressFBWarnings(justification="Intenionally used to access the file system", value={"URLCONNECTION_SSRF_FD"})
    public static String getLogo() {
        String string = "";
        try (InputStream inputStream = Resources.getResource((String)Default.LOGO_FILE.toString()).openStream();){
            string = IOUtils.toString((InputStream)inputStream, (String)Default.ENCODING.toString());
        }
        catch (IOException iOException) {
            LOG.error("Failed to get application logo", (Throwable)iOException);
        }
        return string;
    }

    private static int getBitLength(String string) {
        Objects.requireNonNull(string, Required.SECRET.toString());
        return ByteUtils.bitLength(RegExUtils.replaceAll((String)string, (String)"[^\\x00-\\x7F]", (String)""));
    }

    private static List<com.google.inject.Module> getModules() {
        ArrayList<com.google.inject.Module> arrayList = new ArrayList<com.google.inject.Module>();
        try {
            arrayList.add((com.google.inject.Module)new Module());
            arrayList.add((com.google.inject.Module)((AbstractModule)Class.forName(Default.MODULE_CLASS.toString()).getConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            LOG.error("Failed to load modules. Check that app/Module.java exists in your application", (Throwable)exception);
            Application.failsafe();
        }
        return arrayList;
    }

    private static void applicationStarted() {
        Application.getInstance(MangooBootstrap.class).applicationStarted();
    }

    private static void prepareScheduler() {
        Config config = Application.getInstance(Config.class);
        if (config.isSchedulerEnabled()) {
            ArrayList arrayList = new ArrayList();
            try (Object object = new ClassGraph().enableAnnotationInfo().enableClassInfo().whitelistPackages(new String[]{config.getSchedulerPackage()}).scan();){
                object.getClassesWithAnnotation(Default.SCHEDULER_ANNOTATION.toString()).forEach(classInfo -> arrayList.add(classInfo.loadClass()));
            }
            if (!arrayList.isEmpty() && config.isSchedulerAutostart()) {
                object = Application.getInstance(Scheduler.class);
                ((Scheduler)object).initialize();
                for (Class clazz : arrayList) {
                    Schedule schedule = clazz.getDeclaredAnnotation(Schedule.class);
                    String string = schedule.cron();
                    Trigger trigger = null;
                    JobDetail jobDetail = SchedulerUtils.createJobDetail(clazz.getName(), Default.SCHEDULER_JOB_GROUP.toString(), clazz.asSubclass(Job.class));
                    if (string == null) continue;
                    if ((string = string.toLowerCase(Locale.ENGLISH).trim()).contains("every")) {
                        string = string.replace("every", "").trim();
                        String string2 = string.substring(0, string.length() - 1);
                        String string3 = string.substring(string.length() - 1);
                        String string4 = clazz.getName() + "-trigger";
                        String string5 = schedule.description();
                        String string6 = Default.SCHEDULER_TRIGGER_GROUP.toString();
                        int n = Integer.parseInt(string2);
                        switch (string3) {
                            case "s": {
                                trigger = SchedulerUtils.createTrigger(string4, string6, string5, n, TimeUnit.SECONDS);
                                break;
                            }
                            case "m": {
                                trigger = SchedulerUtils.createTrigger(string4, string6, string5, n, TimeUnit.MINUTES);
                                break;
                            }
                            case "h": {
                                trigger = SchedulerUtils.createTrigger(string4, string6, string5, n, TimeUnit.HOURS);
                                break;
                            }
                            case "d": {
                                trigger = SchedulerUtils.createTrigger(string4, string6, string5, n, TimeUnit.DAYS);
                                break;
                            }
                        }
                    } else if (CronExpression.isValidExpression((String)schedule.cron())) {
                        trigger = SchedulerUtils.createTrigger(clazz.getName() + "-trigger", Default.SCHEDULER_TRIGGER_GROUP.toString(), schedule.description(), schedule.cron());
                    } else {
                        LOG.error("Invalid or missing cron expression for job: {}", (Object)clazz.getName());
                        Application.failsafe();
                    }
                    try {
                        ((Scheduler)object).schedule(jobDetail, trigger);
                        LOG.info("Successfully scheduled job {} with cron {} ", (Object)clazz.getName(), (Object)schedule.cron());
                    }
                    catch (MangooSchedulerException mangooSchedulerException) {
                        LOG.error("Failed to add a job to the scheduler", (Throwable)mangooSchedulerException);
                    }
                }
                try {
                    ((Scheduler)object).start();
                }
                catch (MangooSchedulerException mangooSchedulerException) {
                    LOG.error("Failed to start the scheduler", (Throwable)mangooSchedulerException);
                    Application.failsafe();
                }
            }
        }
    }

    private static void failsafe() {
        System.out.print("Failed to start mangoo I/O application");
        System.exit(1);
    }

    static {
        start = LocalDateTime.now();
    }
}

