/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.name.Names;
import de.svenkubiak.embeddedmongodb.EmbeddedMongoDB;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Config;
import io.mangoo.interfaces.MangooAuthorizationService;
import io.mangoo.scheduler.SchedulerFactory;
import io.mangoo.services.AuthorizationService;
import java.util.Properties;
import org.quartz.spi.JobFactory;

public class Module
extends AbstractModule {
    private Config config = new Config();

    public Module() {
        if (this.config.isMongoEmbedded()) {
            EmbeddedMongoDB.create().withHost(this.config.getMongoHost()).withPort(this.config.getMongoPort()).start();
        }
    }

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.config.toProperties());
        this.bind(JobFactory.class).to(SchedulerFactory.class);
        this.bind(Cache.class).toProvider(CacheProvider.class);
        this.bind(MangooAuthorizationService.class).to(AuthorizationService.class);
    }
}

