/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.crypto.totp;

import com.google.common.base.Preconditions;

public final class OTPKey {
    private final String key;
    private final OTPType type;

    public OTPKey(String string, OTPType oTPType) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)((Object)oTPType));
        this.key = string;
        this.type = oTPType;
    }

    public String getKey() {
        return this.key;
    }

    public OTPType getType() {
        return this.type;
    }

    public static enum OTPType {
        HOTP("HOTP"),
        TOTP("TOTP");

        private final String name;

        private OTPType(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public OTPType from(String string) {
            for (OTPType oTPType : OTPType.values()) {
                if (!oTPType.name.equals(string)) continue;
                return oTPType;
            }
            throw new IllegalArgumentException("No matching OTPType constant for [" + string + "]");
        }

        public String toString() {
            return this.name;
        }
    }
}

