/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.crypto.totp;

import com.google.common.base.Preconditions;
import io.mangoo.crypto.totp.TOTP;
import io.mangoo.crypto.totp.TOTPBuilder;
import io.mangoo.enums.HmacShaAlgorithm;

public final class TOTPValidator {
    public static final int DEFAULT_WINDOW = 1;
    private final int window;

    private TOTPValidator(int n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
        this.window = n;
    }

    public static TOTPValidator defaultWindow() {
        return TOTPValidator.window(1);
    }

    public static TOTPValidator window(int n) {
        return new TOTPValidator(n);
    }

    public boolean isValid(byte[] byArray, long l, int n, HmacShaAlgorithm hmacShaAlgorithm, String string) {
        return this.isValid(byArray, l, n, hmacShaAlgorithm, string, System.currentTimeMillis());
    }

    public boolean isValid(byte[] byArray, long l, int n, HmacShaAlgorithm hmacShaAlgorithm, String string, long l2) {
        boolean bl = false;
        TOTPBuilder tOTPBuilder = TOTP.key(byArray).timeStep(l).digits(n).hmacSha(hmacShaAlgorithm);
        for (int i = -this.window; i <= this.window; ++i) {
            long l3 = l2 + (long)i * l;
            TOTP tOTP = tOTPBuilder.build(l3);
            if (!tOTP.value().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

