/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.email;

import com.google.common.base.Preconditions;
import io.mangoo.core.Application;
import io.mangoo.email.MailEvent;
import io.mangoo.enums.Required;
import io.mangoo.exceptions.MangooMailerException;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.templating.TemplateContext;
import io.mangoo.templating.TemplateEngine;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.email.EmailBuilder;

public class Mail {
    private static final int LOWEST_PRIORITY = 5;
    private static final int HIGHEST_PRIORITY = 1;
    private EmailPopulatingBuilder email = EmailBuilder.startingBlank();

    public static Mail newMail() {
        return new Mail();
    }

    public Mail to(String ... stringArray) {
        Objects.requireNonNull(stringArray, Required.TOS.toString());
        this.email.toMultiple(stringArray);
        return this;
    }

    public Mail to(String string) {
        Objects.requireNonNull(string, Required.TO.toString());
        this.email.to(string);
        return this;
    }

    public Mail cc(String ... stringArray) {
        Objects.requireNonNull(stringArray, Required.CCS.toString());
        this.email.ccMultiple(stringArray);
        return this;
    }

    public Mail cc(String string) {
        Objects.requireNonNull(string, Required.CC.toString());
        this.email.cc(string);
        return this;
    }

    public Mail bcc(String ... stringArray) {
        Objects.requireNonNull(stringArray, Required.BCCS.toString());
        this.email.bccMultiple(stringArray);
        return this;
    }

    public Mail bcc(String string) {
        Objects.requireNonNull(string, Required.BCC.toString());
        this.email.bcc(string);
        return this;
    }

    public Mail subject(String string) {
        Objects.requireNonNull(string, Required.SUBJECT.toString());
        this.email.withSubject(string);
        return this;
    }

    public Mail from(String string, String string2) {
        Objects.requireNonNull(string, Required.FROM.toString());
        Objects.requireNonNull(string2, Required.NAME.toString());
        this.email.from(string, string2);
        return this;
    }

    public Mail header(String string, String string2) {
        Objects.requireNonNull(string, Required.NAME.toString());
        Objects.requireNonNull(string2, Required.VALUE.toString());
        this.email.withHeader(string, (Object)string2);
        return this;
    }

    public Mail replyTo(String string) {
        Objects.requireNonNull(string, Required.REPLY_TO.toString());
        this.email.withReplyTo(string);
        return this;
    }

    public Mail priority(int n) {
        Preconditions.checkArgument((n >= 1 && n <= 5 ? 1 : 0) != 0, (Object)Required.PRIORITY.toString());
        this.email.withHeader("X-Priority", (Object)n);
        return this;
    }

    public Mail attachment(File file) {
        Objects.requireNonNull(file, Required.FILE.toString());
        this.email.withAttachment(file.getName(), (DataSource)new FileDataSource(file));
        return this;
    }

    public Mail textMessage(String string) {
        this.email.appendText(string);
        return this;
    }

    public Mail htmlMessage(String string) {
        this.email.appendTextHTML(string);
        return this;
    }

    public Mail textMessage(String string, Map<String, Object> map) throws MangooTemplateEngineException {
        Objects.requireNonNull(string, Required.TEMPLATE.toString());
        this.email.appendText(this.render(string, map));
        return this;
    }

    public Mail htmlMessage(String string, Map<String, Object> map) throws MangooTemplateEngineException {
        Objects.requireNonNull(string, Required.TEMPLATE.toString());
        this.email.appendTextHTML(this.render(string, map));
        return this;
    }

    public void send() throws MangooMailerException {
        Application.getInstance(MailEvent.class).send(this.email.buildEmail());
    }

    private String render(String string, Map<String, Object> map) throws MangooTemplateEngineException {
        if (string.charAt(0) == '/' || string.startsWith("\\")) {
            string = string.substring(1, string.length());
        }
        TemplateContext templateContext = new TemplateContext(map).withTemplatePath(string);
        return Application.getInstance(TemplateEngine.class).renderTemplate(templateContext);
    }
}

