/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.enums;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum Binding {
    AUTHENTICATION("io.mangoo.routing.bindings.Authentication"),
    DOUBLE("java.lang.Double"),
    DOUBLE_PRIMITIVE("double"),
    FLASH("io.mangoo.routing.bindings.Flash"),
    FLOAT("java.lang.Float"),
    FLOAT_PRIMITIVE("float"),
    FORM("io.mangoo.routing.bindings.Form"),
    INT_PRIMITIVE("int"),
    INTEGER("java.lang.Integer"),
    LOCALDATE("java.time.LocalDate"),
    LOCALDATETIME("java.time.LocalDateTime"),
    LONG("java.lang.Long"),
    LONG_PRIMITIVE("long"),
    MESSAGES("io.mangoo.i18n.Messages"),
    OPTIONAL("java.util.Optional"),
    REQUEST("io.mangoo.routing.bindings.Request"),
    SESSION("io.mangoo.routing.bindings.Session"),
    STRING("java.lang.String"),
    UNDEFINED("undefined");

    private final String value;
    private static Map<String, Binding> values;

    private Binding(String string2) {
        this.value = string2;
    }

    public static Binding fromString(String string) {
        return values.get(string.toLowerCase(Locale.ENGLISH));
    }

    public String toString() {
        return this.value;
    }

    static {
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)Binding.values().length);
        for (Binding binding : Binding.values()) {
            hashMap.put(binding.toString().toLowerCase(Locale.ENGLISH), binding);
        }
        values = Collections.unmodifiableMap(hashMap);
    }
}

