/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.persistence;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import dev.morphia.Morphia;
import dev.morphia.query.Query;
import io.mangoo.core.Config;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;

@Singleton
public class Datastore {
    private static final Logger LOG = LogManager.getLogger(Datastore.class);
    private dev.morphia.Datastore datastore;
    private Morphia morphia;
    private MongoClient mongoClient;
    private Config config;

    @Inject
    public Datastore(Config config) {
        this.config = config;
        this.connect();
        this.morphify();
    }

    public dev.morphia.Datastore getDatastore() {
        return this.datastore;
    }

    public dev.morphia.Datastore query() {
        return this.datastore;
    }

    public Morphia getMorphia() {
        return this.morphia;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    private void connect() {
        String string = this.config.getMongoHost();
        int n = this.config.getMongoPort();
        String string2 = this.config.getMongoUsername();
        String string3 = this.config.getMongoPassword();
        String string4 = this.config.getMongoAuthDB();
        if (this.config.isMongoAuth() && StringUtils.isNotBlank((CharSequence)string2) && StringUtils.isNotBlank((CharSequence)string3) && StringUtils.isNotBlank((CharSequence)string4)) {
            MongoClientOptions mongoClientOptions = MongoClientOptions.builder().build();
            MongoCredential mongoCredential = MongoCredential.createScramSha1Credential((String)string2, (String)string4, (char[])string3.toCharArray());
            this.mongoClient = new MongoClient(new ServerAddress(string, n), mongoCredential, mongoClientOptions);
            LOG.info("Successfully created MongoClient @ {}:{} with authentication", (Object)string, (Object)n);
        } else {
            this.mongoClient = new MongoClient(string, n);
            LOG.info("Successfully created MongoClient @ {}:{} ***without**** authentication", (Object)string, (Object)n);
        }
    }

    private void morphify() {
        String string = this.config.getMongoPackage();
        String string2 = this.config.getMongoDbName();
        this.morphia = new Morphia().mapPackage(string);
        this.datastore = this.morphia.createDatastore(this.mongoClient, string2);
        LOG.info("Mapped Morphia models of package '" + string + "' and created Morphia Datastore with database '" + string2 + "'");
    }

    public void ensureIndexes() {
        this.datastore.ensureIndexes();
    }

    public void ensureCaps() {
        this.datastore.ensureCaps();
    }

    public <T> T findById(Object object, Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to find an object by id, but given class is null");
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to find an object by id, but given id is null");
        return (T)((Query)this.datastore.createQuery(clazz).field("_id").equal(object instanceof ObjectId ? object : new ObjectId(String.valueOf(object)))).first();
    }

    public <T> List<T> findAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to get all morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).find().toList();
    }

    public <T> long countAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to count all a morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).count();
    }

    public void save(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to save a morphia object, but a given object is null");
        this.datastore.save(object);
    }

    public void delete(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to delete a morphia object, but given object is null");
        this.datastore.delete(object);
    }

    public <T> void deleteAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to delete list of mapped morphia objects, but given class is null");
        this.datastore.delete(this.datastore.createQuery(clazz));
    }

    public void dropDatabase() {
        this.datastore.getDatabase().drop();
    }
}

