/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.CacheName;
import io.mangoo.enums.Required;
import io.mangoo.utils.CodecUtils;
import io.mangoo.utils.TotpUtils;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class Authentication {
    private LocalDateTime expires;
    private String subject;
    private boolean twoFactor;
    private boolean remember;
    private boolean loggedOut;
    private boolean invalid;

    public static Authentication create() {
        return new Authentication();
    }

    public Authentication withExpires(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, Required.EXPIRES.toString());
        if (this.expires == null) {
            this.expires = localDateTime;
        }
        return this;
    }

    public Authentication withSubject(String string) {
        if (StringUtils.isBlank((CharSequence)this.subject)) {
            this.subject = string;
        }
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public LocalDateTime getExpires() {
        return this.expires;
    }

    public boolean isLogout() {
        return this.loggedOut;
    }

    public boolean isRememberMe() {
        return this.remember;
    }

    public boolean isTwoFactor() {
        return this.twoFactor;
    }

    public boolean validLogin(String string, String string2, String string3) {
        Objects.requireNonNull(string, Required.USERNAME.toString());
        Objects.requireNonNull(string2, Required.PASSWORD.toString());
        Objects.requireNonNull(string3, Required.HASH.toString());
        Cache cache = Application.getInstance(CacheProvider.class).getCache(CacheName.AUTH);
        boolean bl = false;
        if (!this.userHasLock(string) && CodecUtils.checkJBCrypt(string2, string3)) {
            bl = true;
        } else {
            cache.getAndIncrementCounter(string);
        }
        return bl;
    }

    public Authentication login(String string) {
        this.subject = string;
        return this;
    }

    public Authentication rememberMe(boolean bl) {
        this.remember = bl;
        return this;
    }

    public Authentication rememberMe() {
        this.remember = true;
        return this;
    }

    public Authentication twoFactorAuthentication(boolean bl) {
        this.twoFactor = bl;
        return this;
    }

    public boolean userHasLock(String string) {
        Objects.requireNonNull(string, Required.USERNAME.toString());
        boolean bl = false;
        Config config = Application.getInstance(Config.class);
        Cache cache = Application.getInstance(CacheProvider.class).getCache(CacheName.AUTH);
        AtomicInteger atomicInteger = cache.getCounter(string);
        if (atomicInteger != null && atomicInteger.get() > config.getAuthenticationLock()) {
            bl = true;
        }
        return bl;
    }

    public boolean validSecondFactor(String string, String string2) {
        Objects.requireNonNull(string, Required.SECRET.toString());
        Objects.requireNonNull(string2, Required.TOTP.toString());
        return TotpUtils.verifiedTotp(string, string2);
    }

    public void logout() {
        this.loggedOut = true;
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.subject);
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

