/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import io.mangoo.enums.Required;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Flash {
    private static final Logger LOG = LogManager.getLogger(Flash.class);
    private static final Set<String> INVALID_CHARACTERS = Set.of("|", ":", "&", " ");
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String SUCCESS = "success";
    private Map<String, String> values = new HashMap<String, String>();
    private boolean discard;
    private boolean invalid;

    public static Flash create() {
        return new Flash();
    }

    public Flash withContent(Map<String, String> map) {
        Objects.requireNonNull(map, Required.VALUES.toString());
        this.values = map;
        return this;
    }

    public void setError(String string) {
        if (this.validCharacters(string)) {
            this.values.put(ERROR, string);
        }
    }

    public void setWarning(String string) {
        if (this.validCharacters(string)) {
            this.values.put(WARNING, string);
        }
    }

    public void setSuccess(String string) {
        if (this.validCharacters(string)) {
            this.values.put(SUCCESS, string);
        }
    }

    public void put(String string, String string2) {
        if (this.validCharacters(string) && this.validCharacters(string2)) {
            this.values.put(string, string2);
        }
    }

    public void invalidate() {
        this.invalid = true;
    }

    public String get(String string) {
        return this.values.get(string);
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public Flash setDiscard(boolean bl) {
        this.discard = bl;
        return this;
    }

    public boolean hasContent() {
        return !this.values.isEmpty();
    }

    private boolean validCharacters(String string) {
        if (INVALID_CHARACTERS.contains(string)) {
            LOG.error("Flash key or value can not contain the following characters: spaces, |, & or :");
            return false;
        }
        return true;
    }
}

