/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import io.mangoo.enums.Required;
import io.mangoo.routing.bindings.Validator;
import io.mangoo.utils.MangooUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Form
extends Validator {
    private static final long serialVersionUID = -5815141142864033904L;
    private transient List<InputStream> files = new ArrayList<InputStream>();
    private Map<String, List<String>> valueMap = new HashMap<String, List<String>>();
    private boolean submitted;
    private boolean keep;

    public Optional<String> getString(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        String string2 = (String)this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return Optional.of(string2);
        }
        return Optional.empty();
    }

    public String getValue(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        String string2 = (String)this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            return string2;
        }
        return "";
    }

    public Optional<Boolean> getBoolean(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        String string2 = (String)this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            if ("1".equals(string2)) {
                return Optional.of(Boolean.TRUE);
            }
            if ("true".equals(string2)) {
                return Optional.of(Boolean.TRUE);
            }
            if ("false".equals(string2)) {
                return Optional.of(Boolean.FALSE);
            }
            if ("0".equals(string2)) {
                return Optional.of(Boolean.FALSE);
            }
        }
        return Optional.empty();
    }

    public Optional<Integer> getInteger(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        String string2 = (String)this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2) && NumberUtils.isCreatable((String)string2)) {
            return Optional.of(Integer.valueOf(string2));
        }
        return Optional.empty();
    }

    public Optional<Double> getDouble(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        String string2 = (String)this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2) && NumberUtils.isCreatable((String)string2)) {
            return Optional.of(Double.valueOf(string2));
        }
        return Optional.empty();
    }

    public Optional<Float> getFloat(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        String string2 = (String)this.values.get(string);
        if (StringUtils.isNotBlank((CharSequence)string2) && NumberUtils.isCreatable((String)string2)) {
            return Optional.of(Float.valueOf(string2));
        }
        return Optional.empty();
    }

    public List<InputStream> getFiles() {
        return new ArrayList<InputStream>(this.files);
    }

    public Optional<InputStream> getFile() {
        if (!this.files.isEmpty()) {
            return Optional.of(this.files.get(0));
        }
        return Optional.empty();
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void addFile(InputStream inputStream) {
        this.files.add(inputStream);
    }

    public void keep() {
        this.keep = true;
    }

    public void addValueList(String string, String string2) {
        Objects.requireNonNull(string, Required.KEY.toString());
        if (!this.valueMap.containsKey(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            this.valueMap.put(string, arrayList);
        } else {
            List<String> list = this.valueMap.get(string);
            list.add(string2);
            this.valueMap.put(string, list);
        }
    }

    public List<String> getValueList(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        return this.valueMap.get(string);
    }

    public boolean isKept() {
        return this.keep;
    }

    public void discard() {
        if (this.files != null) {
            this.files.forEach(MangooUtils::closeQuietly);
        }
        this.valueMap = new HashMap<String, List<String>>();
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean bl) {
        this.submitted = bl;
    }
}

