/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import com.google.common.collect.ImmutableMap;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import io.mangoo.enums.Header;
import io.mangoo.enums.Required;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.bindings.Session;
import io.mangoo.routing.bindings.Validator;
import io.mangoo.utils.JsonUtils;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Request
extends Validator {
    private static final long serialVersionUID = 1901891944955577394L;
    private transient HttpServerExchange httpServerExchange;
    private transient Session session;
    private transient Authentication authentication;
    private transient Map<String, Cookie> cookies;
    private transient Map<String, Object> attributes = new HashMap<String, Object>();
    private String body;
    private String authenticity;
    private Map<String, String> parameter;

    public Request() {
    }

    public Request(HttpServerExchange httpServerExchange) {
        Objects.requireNonNull(httpServerExchange, Required.HTTP_SERVER_EXCHANGE.toString());
        this.httpServerExchange = httpServerExchange;
        this.cookies = httpServerExchange.getRequestCookies() == null ? new HashMap() : ImmutableMap.copyOf((Map)httpServerExchange.getRequestCookies());
    }

    public Request withSession(Session session) {
        this.session = session;
        return this;
    }

    public Request withAuthenticity(String string) {
        this.authenticity = string;
        return this;
    }

    public Request withAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public Request withParameter(Map<String, String> map) {
        this.parameter = map;
        this.setValues(this.parameter);
        return this;
    }

    public Request withBody(String string) {
        this.body = string;
        return this;
    }

    public Session getSession() {
        return this.session;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, Object> getBodyAsJsonMap() {
        if (StringUtils.isNotBlank((CharSequence)this.body)) {
            return JsonUtils.fromJson(this.body, Map.class);
        }
        return new HashMap<String, Object>();
    }

    public ReadContext getBodyAsJsonPath() {
        return JsonPath.parse((String)this.body);
    }

    public boolean authenticityMatches() {
        return this.session.getAuthenticity().equals(this.authenticity);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public String getParameter(String string) {
        return this.parameter.get(string);
    }

    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public HeaderMap getHeaders() {
        return this.httpServerExchange.getRequestHeaders();
    }

    public String getAcceptLanguage() {
        return this.getHeader(Header.ACCEPT_LANGUAGE.toHttpString());
    }

    public String getHeader(HttpString httpString) {
        return this.httpServerExchange.getRequestHeaders().get(httpString) == null ? null : this.httpServerExchange.getRequestHeaders().get(httpString).element();
    }

    public String getURI() {
        return this.httpServerExchange.getRequestURI();
    }

    public String getURL() {
        return this.httpServerExchange.getRequestURL();
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public Cookie getCookie(String string) {
        return this.cookies.get(string);
    }

    public String getScheme() {
        return this.httpServerExchange.getRequestScheme();
    }

    public String getCharset() {
        return this.httpServerExchange.getRequestCharset();
    }

    public void addAttribute(String string, Object object) {
        Objects.requireNonNull(string, Required.KEY.toString());
        this.attributes.put(string, object);
    }

    public long getContentLength() {
        return this.httpServerExchange.getRequestContentLength();
    }

    public HttpString getMethod() {
        return this.httpServerExchange.getRequestMethod();
    }

    public String getPath() {
        return this.httpServerExchange.getRequestPath();
    }

    public Object getAttribute(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        return this.attributes.get(string);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

