/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import io.mangoo.enums.Required;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Session {
    private static final Logger LOG = LogManager.getLogger(Session.class);
    private static final Set<String> INVALID_CHRACTERTS = Set.of("|", ":", "&", " ");
    private Map<String, String> values = new HashMap<String, String>();
    private String authenticity;
    private LocalDateTime expires;
    private boolean changed;
    private boolean invalid;

    public static Session create() {
        return new Session();
    }

    public Session withContent(Map<String, String> map) {
        Objects.requireNonNull(map, Required.VALUES.toString());
        this.values = map;
        return this;
    }

    public Session withAuthenticity(String string) {
        Objects.requireNonNull(string, Required.AUTHENTICITY.toString());
        this.authenticity = string;
        return this;
    }

    public Session withExpires(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, Required.EXPIRES.toString());
        this.expires = localDateTime;
        return this;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public boolean hasContent() {
        return !this.values.isEmpty();
    }

    public String get(String string) {
        return this.values.get(string);
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public LocalDateTime getExpires() {
        return this.expires;
    }

    public void put(String string, String string2) {
        if (INVALID_CHRACTERTS.contains(string) || INVALID_CHRACTERTS.contains(string2)) {
            LOG.error("Session key or value can not contain the following characters: spaces, |, & or :");
        } else {
            this.changed = true;
            this.values.put(string, string2);
        }
    }

    public void remove(String string) {
        this.changed = true;
        this.values.remove(string);
    }

    public void clear() {
        this.changed = true;
        this.values = new HashMap<String, String>();
    }

    public boolean hasChanges() {
        return this.changed;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public String getAuthenticity() {
        this.changed = true;
        return this.authenticity;
    }
}

