/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.core.Server;
import io.mangoo.enums.Header;
import io.mangoo.enums.Key;
import io.mangoo.enums.Required;
import io.mangoo.enums.Template;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.handlers.AuthorizationHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AuthenticationHandler
implements HttpHandler {
    private Config config;

    @Inject
    public AuthenticationHandler(Config config) {
        this.config = Objects.requireNonNull(config, Required.CONFIG.toString());
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        if (attachment.hasAuthentication()) {
            Authentication authentication = attachment.getAuthentication();
            if (!authentication.isValid() || authentication.isValid() && authentication.isTwoFactor()) {
                String string = this.config.getString(Key.AUTHENTICATION_REDIRECT.toString());
                if (StringUtils.isNotBlank((CharSequence)string)) {
                    this.endRequest(httpServerExchange, string);
                } else {
                    this.endRequest(httpServerExchange);
                }
            } else {
                this.nextHandler(httpServerExchange);
            }
        } else {
            this.nextHandler(httpServerExchange);
        }
    }

    private void endRequest(HttpServerExchange httpServerExchange, String string) {
        httpServerExchange.setStatusCode(302);
        Server.headers().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> httpServerExchange.getResponseHeaders().add(((Header)((Object)((Object)((Object)entry.getKey())))).toHttpString(), (String)entry.getValue()));
        httpServerExchange.getResponseHeaders().put(Header.LOCATION.toHttpString(), string);
        httpServerExchange.endExchange();
    }

    private void endRequest(HttpServerExchange httpServerExchange) {
        httpServerExchange.setStatusCode(403);
        Server.headers().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> httpServerExchange.getResponseHeaders().add(((Header)((Object)((Object)((Object)entry.getKey())))).toHttpString(), (String)entry.getValue()));
        httpServerExchange.getResponseSender().send(Template.DEFAULT.forbidden());
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(AuthorizationHandler.class).handleRequest(httpServerExchange);
    }
}

