/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import dev.paseto.jpaseto.Paseto;
import dev.paseto.jpaseto.PasetoException;
import dev.paseto.jpaseto.Pasetos;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.ClaimKey;
import io.mangoo.enums.Required;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Session;
import io.mangoo.routing.handlers.AuthenticationHandler;
import io.mangoo.utils.CodecUtils;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboundCookiesHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(InboundCookiesHandler.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final ZoneOffset ZONE_OFFSET = ZoneOffset.UTC;
    private static final int STRING_LENGTH = 32;
    private Config config;
    private Form form;

    @Inject
    public InboundCookiesHandler(Config config) {
        this.config = Objects.requireNonNull(config, Required.CONFIG.toString());
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        attachment.setSession(this.getSessionCookie(httpServerExchange));
        attachment.setAuthentication(this.getAuthenticationCookie(httpServerExchange));
        attachment.setFlash(this.getFlashCookie(httpServerExchange));
        attachment.setForm(this.form);
        httpServerExchange.putAttachment(RequestUtils.getAttachmentKey(), (Object)attachment);
        this.nextHandler(httpServerExchange);
    }

    protected Session getSessionCookie(HttpServerExchange httpServerExchange) {
        Session session = Session.create().withContent(new HashMap<String, String>()).withAuthenticity(MangooUtils.randomString(32)).withExpires(LocalDateTime.now().plusMinutes(this.config.getSessionCookieTokenExpires()));
        String string = this.getCookieValue(httpServerExchange, this.config.getSessionCookieName());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                Paseto paseto = Pasetos.parserBuilder().setSharedSecret(this.config.getSessionCookieSecret().getBytes(CHARSET)).build().parse(string);
                LocalDateTime localDateTime = LocalDateTime.ofInstant(paseto.getClaims().getExpiration(), ZONE_OFFSET);
                if (localDateTime.isAfter(LocalDateTime.now())) {
                    session = Session.create().withContent(MangooUtils.copyMap((Map)paseto.getClaims().get(ClaimKey.DATA.toString(), Map.class))).withAuthenticity((String)paseto.getClaims().get(ClaimKey.AUTHENTICITY.toString(), String.class)).withExpires(LocalDateTime.ofInstant(paseto.getClaims().getExpiration(), ZONE_OFFSET));
                }
            }
            catch (PasetoException pasetoException) {
                LOG.error("Failed to parse session cookie", (Throwable)pasetoException);
                session.invalidate();
            }
        }
        return session;
    }

    protected Authentication getAuthenticationCookie(HttpServerExchange httpServerExchange) {
        Authentication authentication = Authentication.create().withSubject(null).withExpires(LocalDateTime.now().plusMinutes(this.config.getAuthenticationCookieTokenExpires()));
        String string = this.getCookieValue(httpServerExchange, this.config.getAuthenticationCookieName());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                Paseto paseto = Pasetos.parserBuilder().setSharedSecret(this.config.getAuthenticationCookieSecret().getBytes(CHARSET)).build().parse(string);
                LocalDateTime localDateTime = LocalDateTime.ofInstant(paseto.getClaims().getExpiration(), ZONE_OFFSET);
                if (localDateTime.isAfter(LocalDateTime.now())) {
                    authentication = Authentication.create().withExpires(localDateTime).withSubject(paseto.getClaims().getSubject()).twoFactorAuthentication(Boolean.parseBoolean((String)paseto.getClaims().get(ClaimKey.TWO_FACTOR.toString(), String.class)));
                }
            }
            catch (PasetoException pasetoException) {
                LOG.error("Failed to parse authentication cookie", (Throwable)pasetoException);
                authentication.invalidate();
            }
        }
        return authentication;
    }

    protected Flash getFlashCookie(HttpServerExchange httpServerExchange) {
        Flash flash = Flash.create();
        String string = this.getCookieValue(httpServerExchange, this.config.getFlashCookieName());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                Paseto paseto = Pasetos.parserBuilder().setSharedSecret(this.config.getFlashCookieSecret().getBytes(CHARSET)).build().parse(string);
                LocalDateTime localDateTime = LocalDateTime.ofInstant(paseto.getClaims().getExpiration(), ZONE_OFFSET);
                if (localDateTime.isAfter(LocalDateTime.now())) {
                    if (paseto.getClaims().containsKey((Object)ClaimKey.FORM.toString())) {
                        this.form = (Form)CodecUtils.deserializeFromBase64((String)paseto.getClaims().get(ClaimKey.FORM.toString(), String.class));
                    }
                    flash = Flash.create().withContent(MangooUtils.copyMap((Map)paseto.getClaims().get(ClaimKey.DATA.toString(), Map.class))).setDiscard(true);
                }
            }
            catch (PasetoException pasetoException) {
                LOG.error("Failed to parse flash cookie", (Throwable)pasetoException);
                flash.invalidate();
            }
        }
        return flash;
    }

    private String getCookieValue(HttpServerExchange httpServerExchange, String string) {
        Cookie cookie;
        String string2 = null;
        Map map = httpServerExchange.getRequestCookies();
        if (map != null && (cookie = (Cookie)httpServerExchange.getRequestCookies().get(string)) != null) {
            string2 = cookie.getValue();
        }
        return string2;
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(AuthenticationHandler.class).handleRequest(httpServerExchange);
    }
}

