/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Application;
import io.mangoo.enums.CacheName;
import io.mangoo.enums.Header;
import io.mangoo.enums.Required;
import io.mangoo.enums.Template;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.handlers.LocaleHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LimitHandler
implements HttpHandler {
    private Attachment attachment;
    private Cache cache;

    @Inject
    public LimitHandler(CacheProvider cacheProvider) {
        Objects.requireNonNull(cacheProvider, Required.CACHE_PROVIDER.toString());
        this.cache = cacheProvider.getCache(CacheName.REQUEST);
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        if (this.attachment.hasLimit()) {
            String string = this.getCacheKey(httpServerExchange);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                if (this.cache.getAndIncrementCounter(string).get() > this.attachment.getLimit()) {
                    this.endRequest(httpServerExchange);
                } else {
                    this.nextHandler(httpServerExchange);
                }
            } else {
                this.endRequest(httpServerExchange);
            }
        } else {
            this.nextHandler(httpServerExchange);
        }
    }

    private String getCacheKey(HttpServerExchange httpServerExchange) {
        Object object;
        String string = "";
        HeaderMap headerMap = httpServerExchange.getRequestHeaders();
        if (headerMap != null && (object = headerMap.get(Header.X_FORWARDED_FOR.toHttpString())) != null) {
            string = object.element();
        }
        if (StringUtils.isBlank((CharSequence)string) && (object = httpServerExchange.getSourceAddress()) != null) {
            string = ((InetSocketAddress)object).getHostString();
        }
        if (StringUtils.isNotBlank((CharSequence)string)) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        if (StringUtils.isNotBlank((CharSequence)(object = httpServerExchange.getRequestURL()))) {
            object = ((String)object).toLowerCase(Locale.ENGLISH);
        }
        return (String)object + string;
    }

    private void endRequest(HttpServerExchange httpServerExchange) {
        httpServerExchange.setStatusCode(429);
        httpServerExchange.getResponseSender().send(Template.DEFAULT.tooManyRequests());
        httpServerExchange.endExchange();
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        if (this.attachment.hasBasicAuthentication()) {
            HttpHandler httpHandler = RequestUtils.wrapBasicAuthentication(Application.getInstance(LocaleHandler.class), this.attachment.getUsername(), this.attachment.getPassword());
            httpHandler.handleRequest(httpServerExchange);
        } else {
            Application.getInstance(LocaleHandler.class).handleRequest(httpServerExchange);
        }
    }
}

