/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import dev.paseto.jpaseto.PasetoV1LocalBuilder;
import dev.paseto.jpaseto.Pasetos;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.ClaimKey;
import io.mangoo.enums.Required;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Session;
import io.mangoo.routing.handlers.CorsHandler;
import io.mangoo.routing.handlers.ResponseHandler;
import io.mangoo.utils.CodecUtils;
import io.mangoo.utils.DateUtils;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutboundCookiesHandler
implements HttpHandler {
    private static final Logger LOG = LogManager.getLogger(OutboundCookiesHandler.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final ZoneOffset ZONE_OFFSET = ZoneOffset.UTC;
    private static final String ALGORITHM = "AES";
    private static final String SAME_SITE_MODE = "Strict";
    private static final int SIXTY = 60;
    private Attachment attachment;
    private Config config;

    @Inject
    public OutboundCookiesHandler(Config config) {
        this.config = Objects.requireNonNull(config, Required.CONFIG.toString());
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        this.setSessionCookie(httpServerExchange);
        this.setFlashCookie(httpServerExchange);
        this.setAuthenticationCookie(httpServerExchange);
        this.nextHandler(httpServerExchange);
    }

    protected void setSessionCookie(HttpServerExchange httpServerExchange) {
        Session session = this.attachment.getSession();
        if (session.isInvalid()) {
            Cookie cookie = new CookieImpl(this.config.getSessionCookieName()).setSecure(this.config.isSessionCookieSecure()).setValue("").setHttpOnly(true).setPath("/").setMaxAge(Integer.valueOf(0)).setSameSite(true).setSameSiteMode(SAME_SITE_MODE).setDiscard(true);
            httpServerExchange.setResponseCookie(cookie);
        } else if (session.hasChanges()) {
            PasetoV1LocalBuilder pasetoV1LocalBuilder = ((PasetoV1LocalBuilder)((PasetoV1LocalBuilder)((PasetoV1LocalBuilder)Pasetos.V1.LOCAL.builder().setExpiration(session.getExpires().toInstant(ZONE_OFFSET))).claim(ClaimKey.AUTHENTICITY.toString(), (Object)session.getAuthenticity())).claim(ClaimKey.DATA.toString(), session.getValues())).setSharedSecret((SecretKey)new SecretKeySpec(this.config.getSessionCookieSecret().getBytes(CHARSET), ALGORITHM));
            try {
                Cookie cookie = new CookieImpl(this.config.getSessionCookieName()).setValue(pasetoV1LocalBuilder.compact()).setSameSite(true).setSameSiteMode(SAME_SITE_MODE).setHttpOnly(true).setPath("/").setSecure(this.config.isSessionCookieSecure());
                if (this.config.isSessionCookieExpires()) {
                    cookie.setExpires(DateUtils.localDateTimeToDate(session.getExpires()));
                }
                httpServerExchange.setResponseCookie(cookie);
            }
            catch (Exception exception) {
                LOG.error("Failed to generate session cookie", (Throwable)exception);
            }
        }
    }

    protected void setAuthenticationCookie(HttpServerExchange httpServerExchange) {
        Authentication authentication = this.attachment.getAuthentication();
        if (authentication.isInvalid() || authentication.isLogout()) {
            Cookie cookie = new CookieImpl(this.config.getAuthenticationCookieName()).setSecure(this.config.isAuthenticationCookieSecure()).setValue("").setHttpOnly(true).setPath("/").setMaxAge(Integer.valueOf(0)).setSameSite(true).setSameSiteMode(SAME_SITE_MODE).setDiscard(true);
            httpServerExchange.setResponseCookie(cookie);
        } else if (authentication.isValid()) {
            if (authentication.isRememberMe()) {
                authentication.withExpires(LocalDateTime.now().plusHours(this.config.getAuthenticationCookieRememberExpires()));
            }
            PasetoV1LocalBuilder pasetoV1LocalBuilder = ((PasetoV1LocalBuilder)((PasetoV1LocalBuilder)((PasetoV1LocalBuilder)Pasetos.V1.LOCAL.builder().setSubject(authentication.getSubject())).setExpiration(authentication.getExpires().toInstant(ZONE_OFFSET))).claim(ClaimKey.TWO_FACTOR.toString(), (Object)String.valueOf(authentication.isTwoFactor()))).setSharedSecret((SecretKey)new SecretKeySpec(this.config.getAuthenticationCookieSecret().getBytes(CHARSET), ALGORITHM));
            Cookie cookie = new CookieImpl(this.config.getAuthenticationCookieName()).setValue(pasetoV1LocalBuilder.compact()).setSecure(this.config.isAuthenticationCookieSecure()).setHttpOnly(true).setSameSite(true).setPath("/").setSameSiteMode(SAME_SITE_MODE);
            if (this.config.isAuthenticationCookieExpires()) {
                cookie.setExpires(DateUtils.localDateTimeToDate(authentication.getExpires()));
            }
            httpServerExchange.setResponseCookie(cookie);
        }
    }

    protected void setFlashCookie(HttpServerExchange httpServerExchange) {
        Flash flash = this.attachment.getFlash();
        Form form = this.attachment.getForm();
        if (flash.isDiscard() || flash.isInvalid()) {
            Cookie cookie = new CookieImpl(this.config.getFlashCookieName()).setHttpOnly(true).setValue("").setSecure(this.config.isFlashCookieSecure()).setPath("/").setSameSite(true).setSameSiteMode(SAME_SITE_MODE).setDiscard(true).setMaxAge(Integer.valueOf(0));
            httpServerExchange.setResponseCookie(cookie);
        } else if (flash.hasContent() || form.isKept()) {
            try {
                PasetoV1LocalBuilder pasetoV1LocalBuilder = ((PasetoV1LocalBuilder)Pasetos.V1.LOCAL.builder().claim(ClaimKey.DATA.toString(), flash.getValues())).setSharedSecret((SecretKey)new SecretKeySpec(this.config.getFlashCookieSecret().getBytes(CHARSET), ALGORITHM));
                if (form.isKept()) {
                    pasetoV1LocalBuilder.claim(ClaimKey.FORM.toString(), (Object)CodecUtils.serializeToBase64(form));
                }
                LocalDateTime localDateTime = LocalDateTime.now().plusSeconds(60L);
                pasetoV1LocalBuilder.setExpiration(localDateTime.toInstant(ZONE_OFFSET));
                Cookie cookie = new CookieImpl(this.config.getFlashCookieName()).setValue(pasetoV1LocalBuilder.compact()).setSecure(this.config.isFlashCookieSecure()).setHttpOnly(true).setSameSite(true).setPath("/").setSameSiteMode(SAME_SITE_MODE).setExpires(DateUtils.localDateTimeToDate(localDateTime));
                httpServerExchange.setResponseCookie(cookie);
            }
            catch (Exception exception) {
                LOG.error("Failed to generate flash cookie", (Throwable)exception);
            }
        }
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        if (this.config.isCorsEnable()) {
            Application.getInstance(CorsHandler.class).handleRequest(httpServerExchange);
        } else {
            Application.getInstance(ResponseHandler.class).handleRequest(httpServerExchange);
        }
    }
}

