/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.common.io.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.annotations.FilterWith;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Application;
import io.mangoo.enums.Binding;
import io.mangoo.enums.CacheName;
import io.mangoo.enums.Default;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.interfaces.filters.OncePerRequestFilter;
import io.mangoo.interfaces.filters.PerRequestFilter;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.routing.handlers.OutboundCookiesHandler;
import io.mangoo.templating.TemplateContext;
import io.mangoo.utils.JsonUtils;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestHandler
implements HttpHandler {
    private Attachment attachment;

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        this.attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        this.attachment.setBody(this.getRequestBody(httpServerExchange));
        this.attachment.setRequest(this.getRequest(httpServerExchange));
        Response response = this.getResponse(httpServerExchange);
        response.getCookies().forEach(arg_0 -> ((HttpServerExchange)httpServerExchange).setResponseCookie(arg_0));
        this.attachment.setResponse(response);
        httpServerExchange.putAttachment(RequestUtils.getAttachmentKey(), (Object)this.attachment);
        this.nextHandler(httpServerExchange);
    }

    protected Request getRequest(HttpServerExchange httpServerExchange) {
        String string = Optional.ofNullable(this.attachment.getRequestParameter().get(Default.AUTHENTICITY.toString())).orElse(this.attachment.getForm().get(Default.AUTHENTICITY.toString()));
        return new Request(httpServerExchange).withSession(this.attachment.getSession()).withAuthenticity(string).withAuthentication(this.attachment.getAuthentication()).withParameter(this.attachment.getRequestParameter()).withBody(this.attachment.getBody());
    }

    protected Response getResponse(HttpServerExchange httpServerExchange) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, MangooTemplateEngineException, IOException {
        Response response = Response.withOk();
        if (this.attachment.hasRequestFilter()) {
            OncePerRequestFilter oncePerRequestFilter = Application.getInstance(OncePerRequestFilter.class);
            response = oncePerRequestFilter.execute(this.attachment.getRequest(), response);
        }
        if (response.isEndResponse()) {
            return response;
        }
        response = this.executeFilter(this.attachment.getClassAnnotations(), response);
        if (response.isEndResponse()) {
            return response;
        }
        response = this.executeFilter(this.attachment.getMethodAnnotations(), response);
        if (response.isEndResponse()) {
            return response;
        }
        return this.invokeController(httpServerExchange, response);
    }

    protected Response invokeController(HttpServerExchange httpServerExchange, Response response) throws IllegalAccessException, InvocationTargetException, MangooTemplateEngineException, IOException {
        Object object;
        Response response2;
        if (this.attachment.getMethodParameters().isEmpty()) {
            response2 = (Response)this.attachment.getMethod().invoke(this.attachment.getControllerInstance(), new Object[0]);
        } else {
            object = this.getConvertedParameters(httpServerExchange);
            response2 = (Response)this.attachment.getMethod().invoke(this.attachment.getControllerInstance(), (Object[])object);
        }
        response2.andContent(response.getContent());
        response2.andHeaders(response.getHeaders());
        if (response2.isRendered()) {
            object = new TemplateContext(response2.getContent()).withFlash(this.attachment.getFlash()).withSession(this.attachment.getSession()).withForm(this.attachment.getForm()).withMessages(this.attachment.getMessages()).withController(this.attachment.getControllerAndMethod()).withPrettyTime(this.attachment.getLocale()).withAuthenticity(this.attachment.getSession()).withAuthenticityForm(this.attachment.getSession()).withTemplatePath(this.getTemplatePath(response2));
            response2.andBody(this.attachment.getTemplateEngine().renderTemplate((TemplateContext)object));
        } else if (response2.isUnrendered()) {
            object = Application.getInstance(CacheProvider.class).getCache(CacheName.RESPONSE);
            String string = "templates/" + this.attachment.getControllerClassName() + "/" + this.attachment.getControllerMethodName() + ".body";
            String string2 = "";
            if (object.get(string) == null) {
                string2 = Resources.toString((URL)Resources.getResource((String)string), (Charset)StandardCharsets.UTF_8);
                object.put(string, string2);
            } else {
                string2 = (String)object.get(string);
            }
            response2.andBody(string2);
        }
        return response2;
    }

    protected String getTemplatePath(Response response) {
        return StringUtils.isBlank((CharSequence)response.getTemplate()) ? this.attachment.getControllerClassName() + "/" + this.attachment.getTemplateEngine().getTemplateName(this.attachment.getControllerMethodName()) : response.getTemplate();
    }

    @SuppressFBWarnings(justification="Intentionally adding unrelated types", value={"UCC_UNRELATED_COLLECTION_CONTENTS"})
    protected Object[] getConvertedParameters(HttpServerExchange httpServerExchange) {
        Object[] objectArray = new Object[this.attachment.getMethodParametersCount()];
        int n = 0;
        for (Map.Entry<String, Class<?>> entry : this.attachment.getMethodParameters().entrySet()) {
            String string = entry.getKey();
            Class<?> clazz = entry.getValue();
            Binding binding = Optional.ofNullable(Binding.fromString(clazz.getName())).orElse(Binding.UNDEFINED);
            switch (binding) {
                case FORM: {
                    objectArray[n] = this.attachment.getForm();
                    break;
                }
                case AUTHENTICATION: {
                    objectArray[n] = this.attachment.getAuthentication();
                    break;
                }
                case SESSION: {
                    objectArray[n] = this.attachment.getSession();
                    break;
                }
                case FLASH: {
                    objectArray[n] = this.attachment.getFlash();
                    break;
                }
                case REQUEST: {
                    objectArray[n] = this.attachment.getRequest();
                    break;
                }
                case MESSAGES: {
                    objectArray[n] = this.attachment.getMessages();
                    break;
                }
                case LOCALDATE: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? null : LocalDate.parse(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case LOCALDATETIME: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? null : LocalDateTime.parse(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case STRING: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? null : this.attachment.getRequestParameter().get(string);
                    break;
                }
                case INT_PRIMITIVE: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? 0 : Integer.parseInt(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case INTEGER: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? null : Integer.valueOf(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case DOUBLE_PRIMITIVE: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? 0.0 : Double.parseDouble(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case DOUBLE: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? null : Double.valueOf(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case FLOAT_PRIMITIVE: {
                    objectArray[n] = Float.valueOf(StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? 0.0f : Float.parseFloat(this.attachment.getRequestParameter().get(string)));
                    break;
                }
                case FLOAT: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? null : Float.valueOf(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case LONG_PRIMITIVE: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? 0L : Long.parseLong(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case LONG: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? null : Long.valueOf(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case OPTIONAL: {
                    objectArray[n] = StringUtils.isBlank((CharSequence)this.attachment.getRequestParameter().get(string)) ? Optional.empty() : Optional.of(this.attachment.getRequestParameter().get(string));
                    break;
                }
                case UNDEFINED: {
                    objectArray[n] = RequestUtils.isJsonRequest(httpServerExchange) ? JsonUtils.fromJson(this.attachment.getBody(), clazz) : null;
                    break;
                }
                default: {
                    objectArray[n] = null;
                }
            }
            ++n;
        }
        return objectArray;
    }

    protected Response executeFilter(List<Annotation> list, Response response) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Annotation annotation : list) {
            FilterWith filterWith = (FilterWith)annotation;
            for (Class<? extends PerRequestFilter> clazz : filterWith.value()) {
                if (response.isEndResponse()) {
                    return response;
                }
                Method method = clazz.getMethod(Default.FILTER_METHOD.toString(), Request.class, Response.class);
                response = (Response)method.invoke((Object)Application.getInstance(clazz), this.attachment.getRequest(), response);
            }
        }
        return response;
    }

    protected String getRequestBody(HttpServerExchange httpServerExchange) throws IOException {
        String string = "";
        if (RequestUtils.isPostPutPatch(httpServerExchange)) {
            httpServerExchange.startBlocking();
            string = IOUtils.toString((InputStream)httpServerExchange.getInputStream(), (String)Default.ENCODING.toString());
        }
        return string;
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(OutboundCookiesHandler.class).handleRequest(httpServerExchange);
    }
}

