/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.routes;

import io.mangoo.enums.Http;
import io.mangoo.enums.Required;
import io.mangoo.interfaces.MangooRoute;
import io.mangoo.routing.Router;
import io.mangoo.routing.routes.RequestRoute;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ControllerRoute {
    private Class<?> controllerClass;
    private String username;
    private String password;
    private boolean authentication;
    private boolean authorization;
    private boolean blocking;
    private int limit;

    public ControllerRoute(Class<?> clazz) {
        Objects.requireNonNull(clazz, Required.CONTROLLER_CLASS.toString());
        this.controllerClass = clazz;
    }

    public void withRoutes(MangooRoute ... mangooRouteArray) {
        Objects.requireNonNull(mangooRouteArray, Required.ROUTE.toString());
        for (MangooRoute mangooRoute : mangooRouteArray) {
            RequestRoute requestRoute = (RequestRoute)mangooRoute;
            requestRoute.withControllerClass(this.controllerClass);
            if (this.hasBasicAuthentication()) {
                requestRoute.withBasicAuthentication(this.username, this.password);
            }
            if (this.hasAuthentication()) {
                requestRoute.withAuthentication();
            }
            if (this.hasAuthorization()) {
                requestRoute.withAuthorization();
            }
            if (this.hasBlocking()) {
                requestRoute.withNonBlocking();
            }
            if (requestRoute.getLimit() == 0) {
                requestRoute.withRequestLimit(this.limit);
            }
            if (requestRoute.hasMultipleMethods()) {
                for (Http http : requestRoute.getMethods()) {
                    requestRoute.withHttpMethod(http);
                    Router.addRoute(requestRoute);
                }
                continue;
            }
            Router.addRoute(requestRoute);
        }
    }

    public ControllerRoute withBasicAuthentication(String string, String string2) {
        Objects.requireNonNull(string, Required.USERNAME.toString());
        Objects.requireNonNull(string2, Required.PASSWORD.toString());
        this.username = string;
        this.password = string2;
        return this;
    }

    public ControllerRoute withAuthentication() {
        this.authentication = true;
        return this;
    }

    public ControllerRoute withAuthorization() {
        this.authorization = true;
        this.authentication = true;
        return this;
    }

    public ControllerRoute withNonBlocking() {
        this.blocking = true;
        return this;
    }

    public ControllerRoute withRequestLimit(int n) {
        this.limit = n;
        return this;
    }

    public boolean hasAuthentication() {
        return this.authentication;
    }

    public boolean hasAuthorization() {
        return this.authorization;
    }

    public boolean hasBlocking() {
        return this.blocking;
    }

    public boolean hasBasicAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password);
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getLimit() {
        return this.limit;
    }
}

