/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheProvider;
import io.mangoo.enums.CacheName;
import io.mangoo.enums.Default;
import io.mangoo.enums.Required;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.RequestUtils;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Singleton
public class WebSocketService {
    private final Cache cache;

    @Inject
    private WebSocketService(CacheProvider cacheProvider) {
        Objects.requireNonNull(cacheProvider, Required.CACHE_PROVIDER.toString());
        this.cache = cacheProvider.getCache(CacheName.WSS);
    }

    public void addChannel(WebSocketChannel webSocketChannel) {
        Objects.requireNonNull(webSocketChannel, Required.CHANNEL.toString());
        String string = RequestUtils.getWebSocketURL(webSocketChannel);
        Set<WebSocketChannel> set = this.getChannels(string);
        if (set == null) {
            set = new HashSet<WebSocketChannel>();
            set.add(webSocketChannel);
        } else {
            set.add(webSocketChannel);
        }
        this.setChannels(string, set);
    }

    public void setChannels(String string, Set<WebSocketChannel> set) {
        Objects.requireNonNull(string, Required.URI.toString());
        Objects.requireNonNull(set, Required.URI_CONNECTIONS.toString());
        this.cache.put(Default.WSS_CACHE_PREFIX.toString() + string, set);
    }

    public Set<WebSocketChannel> getChannels(String string) {
        Objects.requireNonNull(string, Required.URI.toString());
        Set set = (Set)this.cache.get(Default.WSS_CACHE_PREFIX.toString() + string);
        return set == null ? new HashSet() : set;
    }

    public void removeChannels(String string) {
        Objects.requireNonNull(string, Required.URI.toString());
        this.cache.remove(Default.WSS_CACHE_PREFIX.toString() + string);
    }

    public void close(String string) {
        Objects.requireNonNull(string, Required.URI.toString());
        Set<WebSocketChannel> set = this.getChannels(string);
        if (set != null) {
            set.forEach(webSocketChannel -> {
                if (webSocketChannel.isOpen()) {
                    MangooUtils.closeQuietly((Closeable)webSocketChannel);
                }
            });
            this.removeChannels(string);
        }
    }
}

