/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import io.mangoo.enums.Default;
import io.mangoo.enums.Required;
import java.io.Serializable;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.mindrot.jbcrypt.BCrypt;

public final class CodecUtils {
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();

    private CodecUtils() {
    }

    public static String hexJBcrypt(String string) {
        Objects.requireNonNull(string, Required.DATA.toString());
        return BCrypt.hashpw((String)string, (String)BCrypt.gensalt((int)Default.JBCRYPT_ROUNDS.toInt()));
    }

    public static String hexSHA512(String string) {
        Objects.requireNonNull(string, Required.DATA.toString());
        return DigestUtils.sha512Hex((String)string);
    }

    public static String hexSHA512(String string, String string2) {
        Objects.requireNonNull(string, Required.DATA.toString());
        Objects.requireNonNull(string2, Required.SALT.toString());
        return DigestUtils.sha512Hex((String)(string + string2));
    }

    public static boolean checkJBCrypt(String string, String string2) {
        Objects.requireNonNull(string, Required.DATA.toString());
        Objects.requireNonNull(string2, Required.HASH.toString());
        return BCrypt.checkpw((String)string, (String)string2);
    }

    public static String serializeToBase64(Serializable serializable) {
        Objects.requireNonNull(serializable, Required.OBJECT.toString());
        byte[] byArray = SerializationUtils.serialize((Serializable)serializable);
        return base64Encoder.encodeToString(byArray);
    }

    public static <T> T deserializeFromBase64(String string) {
        Objects.requireNonNull(string, Required.DATA.toString());
        byte[] byArray = base64Decoder.decode(string);
        return (T)SerializationUtils.deserialize((byte[])byArray);
    }
}

