/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import com.google.common.base.Preconditions;
import io.mangoo.enums.Required;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public final class SchedulerUtils {
    private static final int TWENTYFOUR_HORS = 24;

    private SchedulerUtils() {
    }

    public static Trigger createTrigger(String string, String string2, String string3, String string4) {
        Objects.requireNonNull(string, Required.IDENTITY.toString());
        Objects.requireNonNull(string2, Required.GROUP_NAME.toString());
        Objects.requireNonNull(string4, Required.CRON.toString());
        Preconditions.checkArgument((boolean)CronExpression.isValidExpression((String)string4), (Object)"cron expression is invalid");
        return TriggerBuilder.newTrigger().withIdentity(string, string2).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)string4)).withDescription(string3).build();
    }

    public static Trigger createTrigger(String string, String string2, String string3, int n, TimeUnit timeUnit) {
        Objects.requireNonNull(string, Required.IDENTITY.toString());
        Objects.requireNonNull(string2, Required.GROUP_NAME.toString());
        Objects.requireNonNull(Integer.valueOf(n), Required.TIMEPSAN.toString());
        Objects.requireNonNull(timeUnit, Required.TIMEUNIT.toString());
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withDescription(string3).withIdentity(string, string2);
        if (timeUnit == TimeUnit.SECONDS) {
            triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)n));
        } else if (timeUnit == TimeUnit.MINUTES) {
            triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever((int)n));
        } else if (timeUnit == TimeUnit.HOURS) {
            triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatHourlyForever((int)n));
        } else if (timeUnit == TimeUnit.DAYS) {
            triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatHourlyForever((int)(n * 24)));
        }
        return triggerBuilder.build();
    }

    public static JobDetail createJobDetail(String string, String string2, Class<? extends Job> clazz) {
        Objects.requireNonNull(string, Required.IDENTITY.toString());
        Objects.requireNonNull(string2, Required.GROUP_NAME.toString());
        Objects.requireNonNull(clazz, Required.CLASS.toString());
        return JobBuilder.newJob(clazz).withIdentity(string, string2).build();
    }
}

