/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.utils;

import io.mangoo.crypto.totp.TOTP;
import io.mangoo.enums.HmacShaAlgorithm;
import io.mangoo.enums.Required;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang3.RegExUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TotpUtils {
    private static final Logger LOG = LogManager.getLogger(TotpUtils.class);
    private static final Base32 base32 = new Base32();
    private static final HmacShaAlgorithm ALGORITHM = HmacShaAlgorithm.HMAC_SHA_512;
    private static final int DIGITS = 6;
    private static final int MAX_CHARACTERS = 32;
    private static final int PERIOD = 30;
    private static final int ITERATIONS = 26;
    private static final int BYTES_SECRET = 64;

    private TotpUtils() {
    }

    public static String createSecret() {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder(64);
        for (int i = 0; i < 64; ++i) {
            int n = secureRandom.nextInt(32);
            if (n < 26) {
                stringBuilder.append((char)(65 + n));
                continue;
            }
            stringBuilder.append((char)(50 + (n - 26)));
        }
        return stringBuilder.toString();
    }

    public static String getTotp(String string) {
        Objects.requireNonNull(string, Required.SECRET.toString());
        String string2 = null;
        try {
            TOTP tOTP = TOTP.key(string.getBytes(StandardCharsets.US_ASCII.name())).timeStep(TimeUnit.SECONDS.toMillis(30L)).digits(6).hmacSha(ALGORITHM).build();
            string2 = tOTP.value();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Failed to create TOTP", (Throwable)unsupportedEncodingException);
        }
        return string2;
    }

    public static String getTotp(String string, HmacShaAlgorithm hmacShaAlgorithm, int n, int n2) {
        Objects.requireNonNull(string, Required.SECRET.toString());
        Objects.requireNonNull(hmacShaAlgorithm, Required.ALGORITHM.toString());
        String string2 = null;
        try {
            TOTP tOTP = TOTP.key(string.getBytes(StandardCharsets.US_ASCII.name())).timeStep(TimeUnit.SECONDS.toMillis(n2)).digits(n).hmacSha(hmacShaAlgorithm).build();
            string2 = tOTP.value();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Failed to create TOTP", (Throwable)unsupportedEncodingException);
        }
        return string2;
    }

    public static boolean verifiedTotp(String string, String string2) {
        Objects.requireNonNull(string, Required.SECRET.toString());
        Objects.requireNonNull(string2, Required.TOTP.toString());
        String string3 = null;
        try {
            TOTP tOTP = TOTP.key(string.getBytes(StandardCharsets.US_ASCII.name())).timeStep(TimeUnit.SECONDS.toMillis(30L)).digits(6).hmacSha(ALGORITHM).build();
            string3 = tOTP.value();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Failed to verify TOTP", (Throwable)unsupportedEncodingException);
        }
        return string2.equals(string3);
    }

    public static String getQRCode(String string, String string2, String string3, HmacShaAlgorithm hmacShaAlgorithm, String string4, String string5) {
        Objects.requireNonNull(string, Required.ACCOUNT_NAME.toString());
        Objects.requireNonNull(string3, Required.SECRET.toString());
        Objects.requireNonNull(string2, Required.ISSUER.toString());
        Objects.requireNonNull(hmacShaAlgorithm, Required.ALGORITHM.toString());
        Objects.requireNonNull(string4, Required.DIGITS.toString());
        Objects.requireNonNull(string5, Required.PERIOD.toString());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://chart.googleapis.com/chart?chs=200x200&cht=qr&chl=200x200&chld=M|0&cht=qr&chl=").append(TotpUtils.getOtpauthURL(string, string2, string3, hmacShaAlgorithm, string4, string5));
        return stringBuilder.toString();
    }

    public static String getOtpauthURL(String string, String string2, String string3, HmacShaAlgorithm hmacShaAlgorithm, String string4, String string5) {
        Objects.requireNonNull(string, Required.ACCOUNT_NAME.toString());
        Objects.requireNonNull(string3, Required.SECRET.toString());
        Objects.requireNonNull(string2, Required.ISSUER.toString());
        Objects.requireNonNull(hmacShaAlgorithm, Required.ALGORITHM.toString());
        Objects.requireNonNull(string4, Required.DIGITS.toString());
        Objects.requireNonNull(string5, Required.PERIOD.toString());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("otpauth://totp/").append(string).append("?secret=").append(RegExUtils.replaceAll((String)base32.encodeAsString(string3.getBytes(StandardCharsets.UTF_8)), (String)"=", (String)"")).append("&algorithm=").append(hmacShaAlgorithm.getAlgorithm()).append("&issuer=").append(string2).append("&digits=").append(string4).append("&period=").append(string5);
        String string6 = "";
        try {
            string6 = URLEncoder.encode(stringBuilder.toString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error("Failed to encode otpauth url", (Throwable)unsupportedEncodingException);
        }
        return string6;
    }
}

