/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import dev.paseto.jpaseto.Paseto;
import dev.paseto.jpaseto.PasetoException;
import dev.paseto.jpaseto.Pasetos;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.Default;
import io.mangoo.interfaces.filters.PerRequestFilter;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.utils.MangooUtils;
import io.undertow.server.handlers.Cookie;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang3.StringUtils;

public class AdminFilter
implements PerRequestFilter {
    private static final String VERSION_TAG = MangooUtils.getVersion();

    @Override
    public Response execute(Request request, Response response) {
        String string;
        Config config = Application.getInstance(Config.class);
        Cookie cookie = request.getCookie(Default.ADMIN_COOKIE_NAME.toString());
        if (cookie != null && StringUtils.isNotBlank((CharSequence)(string = cookie.getValue()))) {
            try {
                Paseto paseto = Pasetos.parserBuilder().setSharedSecret(config.getApplicationSecret().getBytes(StandardCharsets.UTF_8)).build().parse(string);
                LocalDateTime localDateTime = LocalDateTime.ofInstant(paseto.getClaims().getExpiration(), ZoneOffset.UTC);
                if (localDateTime.isAfter(LocalDateTime.now())) {
                    if (paseto.getClaims().containsKey((Object)"twofactor") && ((Boolean)paseto.getClaims().get("twofactor", Boolean.class)).booleanValue()) {
                        return Response.withRedirect("/@admin/twofactor").andEndResponse();
                    }
                    response.andContent("version", VERSION_TAG);
                    return response;
                }
            }
            catch (PasetoException pasetoException) {
                // empty catch block
            }
        }
        return Response.withRedirect("/@admin/login").andEndResponse();
    }
}

