/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.cache;

import io.mangoo.cache.Cache;
import io.mangoo.enums.Required;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheImpl
implements Cache {
    private org.ehcache.Cache<String, Object> ehCache;

    public CacheImpl(org.ehcache.Cache<String, Object> cache) {
        Objects.requireNonNull(cache, Required.EHCACHE.toString());
        this.ehCache = cache;
    }

    @Override
    public void put(String string, Object object) {
        Objects.requireNonNull(string, Required.KEY.toString());
        this.ehCache.put((Object)string, object);
    }

    @Override
    public void remove(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        this.ehCache.remove((Object)string);
    }

    @Override
    public void clear() {
        this.ehCache.clear();
    }

    @Override
    public <T> T get(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        return (T)this.ehCache.get((Object)string);
    }

    @Override
    public void putAll(Map<String, Object> map) {
        Objects.requireNonNull(map, Required.MAP.toString());
        this.ehCache.putAll(map);
    }

    @Override
    public AtomicInteger getAndIncrementCounter(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        AtomicInteger atomicInteger = (AtomicInteger)this.get(string);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(0);
        }
        atomicInteger.incrementAndGet();
        this.put(string, atomicInteger);
        return atomicInteger;
    }

    @Override
    public AtomicInteger getCounter(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        return (AtomicInteger)this.get(string);
    }

    @Override
    public AtomicInteger resetCounter(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        AtomicInteger atomicInteger = (AtomicInteger)this.get(string);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(0);
        }
        this.put(string, atomicInteger);
        return atomicInteger;
    }

    @Override
    public AtomicInteger getAndDecrementCounter(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        AtomicInteger atomicInteger = (AtomicInteger)this.get(string);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(0);
        }
        atomicInteger.decrementAndGet();
        this.put(string, atomicInteger);
        return atomicInteger;
    }
}

