/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.common.io.Resources;
import com.google.inject.Singleton;
import com.google.re2j.Pattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.core.Application;
import io.mangoo.crypto.Crypto;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.Required;
import io.mangoo.exceptions.MangooEncryptionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jodd.props.Props;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class Config {
    private static final Logger LOG = LogManager.getLogger(Config.class);
    private static final String CRYPTEX_TAG = "cryptex{";
    private static final String ARG_TAG = "arg{}";
    private Pattern corsUrl;
    private Pattern corsAllowOrigin;
    private String mode;
    private Props props = Props.create();
    private boolean decrypted = true;

    public Config() {
        this.mode = Application.getMode().toString();
        this.load();
    }

    public Config(String string) {
        this.mode = Objects.requireNonNull(string, Required.MODE.toString());
    }

    @SuppressFBWarnings(justification="Intenionally used to access the file system", value={"URLCONNECTION_SSRF_FD"})
    private final void load() {
        Object object;
        this.props.setActiveProfiles(new String[]{this.mode});
        this.props.setSkipEmptyProps(false);
        String string = System.getProperty(Key.APPLICATION_CONFIG.toString());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                this.props.load(new File(string));
            }
            catch (IOException iOException) {
                LOG.error("Failed to load config.props from {}", (Object)string, (Object)iOException);
            }
        } else {
            try {
                object = Resources.getResource((String)Default.CONFIGURATION_FILE.toString()).openStream();
                try {
                    this.props.load((InputStream)object);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                LOG.error("Failed to load config.props from /src/main/resources/config.props", (Throwable)iOException);
            }
        }
        object = new HashMap();
        this.props.extractProps((Map)object, new String[]{Application.getMode().toString()});
        object.forEach(this::parse);
        System.setProperty(Key.APPLICATION_SECRET.toString(), "");
    }

    private void parse(String string, String string2) {
        if (ARG_TAG.equals(string2)) {
            String string3 = System.getProperty(string);
            if (StringUtils.isNotBlank((CharSequence)string3) && string3.startsWith(CRYPTEX_TAG)) {
                string3 = this.decrypt(string3);
            }
            if (StringUtils.isNotBlank((CharSequence)string3)) {
                this.props.setValue(string, string3, Application.getMode().toString());
            }
        }
        if (string2.startsWith(CRYPTEX_TAG)) {
            this.props.setValue(string, this.decrypt(string2), Application.getMode().toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String decrypt(String string) {
        Crypto crypto = new Crypto(this);
        String string2 = System.getProperty(Key.APPLICATION_PRIVATEKEY.toString());
        if (!StringUtils.isNotBlank((CharSequence)string2)) {
            LOG.error("Found an encrypted value in config file but private key for decryption is missing");
            this.decrypted = false;
            return "";
        }
        try (Stream<String> stream = Files.lines(Paths.get(string2, new String[0]));){
            String string4 = stream.findFirst().orElse(null);
            if (!StringUtils.isNotBlank((CharSequence)string4)) return "";
            PrivateKey privateKey = crypto.getPrivateKeyFromString(string4);
            String string5 = StringUtils.substringBetween((String)string, (String)CRYPTEX_TAG, (String)"}");
            if (privateKey != null && StringUtils.isNotBlank((CharSequence)string5)) {
                String string3 = crypto.decrypt(string5, privateKey);
                return string3;
            }
            LOG.error("Failed to decrypt an encrypted config value");
            this.decrypted = false;
            return "";
        }
        catch (MangooEncryptionException | IOException | SecurityException exception) {
            LOG.error("Failed to decrypt an encrypted config value", (Throwable)exception);
            this.decrypted = false;
            return "";
        }
    }

    public Properties toProperties() {
        HashMap hashMap = new HashMap();
        this.props.extractProps(hashMap);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)hashMap);
        return properties;
    }

    public boolean isDecrypted() {
        return this.decrypted;
    }

    public String getString(String string) {
        return this.props.getValue(string);
    }

    public String getString(String string, String string2) {
        return this.props.getValueOrDefault(string, string2);
    }

    public int getInt(String string) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    public long getLong(String string) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return 0L;
        }
        return Long.parseLong(string2);
    }

    public long getLong(String string, long l) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return l;
        }
        return Long.parseLong(string2);
    }

    public int getInt(String string, int n) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public boolean getBoolean(String string) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return false;
        }
        return Boolean.parseBoolean(string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.props.getValue(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return bl;
        }
        return Boolean.parseBoolean(string2);
    }

    public String getString(Key key) {
        return this.getString(key.toString());
    }

    public String getString(Key key, String string) {
        return this.getString(key.toString(), string);
    }

    public long getLong(Key key) {
        return this.getLong(key.toString());
    }

    public long getLong(Key key, long l) {
        return this.getLong(key.toString(), l);
    }

    public int getInt(Key key) {
        return this.getInt(key.toString());
    }

    public int getInt(Key key, int n) {
        return this.getInt(key.toString(), n);
    }

    public boolean getBoolean(Key key) {
        return this.getBoolean(key.toString());
    }

    public boolean getBoolean(Key key, boolean bl) {
        return this.getBoolean(key.toString(), bl);
    }

    public Map<String, String> getAllConfigurations() {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        this.props.entries().forEach(propsEntry -> concurrentHashMap.put(propsEntry.getKey(), propsEntry.getValue()));
        return concurrentHashMap;
    }

    public String getApplicationName() {
        return this.getString(Key.APPLICATION_NAME);
    }

    public String getFlashCookieName() {
        return this.getString(Key.FLASH_COOKIE_NAME, Default.FLASH_COOKIE_NAME.toString());
    }

    public String getSessionCookieName() {
        return this.getString(Key.SESSION_COOKIE_NAME, Default.SESSION_COOKIE_NAME.toString());
    }

    public String getApplicationSecret() {
        return this.getString(Key.APPLICATION_SECRET);
    }

    public String getApplicationPublicKey() {
        return this.getString(Key.APPLICATION_PUBLICKEY);
    }

    public String getAuthenticationCookieName() {
        return this.getString(Key.AUTHENTICATION_COOKIE_NAME, Default.AUTHENTICATION_COOKIE_NAME.toString());
    }

    public long getSessionCookieTokenExpires() {
        return this.getLong(Key.SESSION_COOKIE_TOKEN_EXPIRES, Default.SESSION_COOKIE_TOKEN_EXPIRES.toLong());
    }

    public boolean isSessionCookieSecure() {
        return this.getBoolean(Key.SESSION_COOKIE_SECURE, Default.SESSION_COOKIE_SECURE.toBoolean());
    }

    public boolean isAuthenticationCookieSecure() {
        return this.getBoolean(Key.AUTHENTICATION_COOKIE_SECURE, Default.AUTHENTICATION_COOKIE_SECURE.toBoolean());
    }

    public String getI18nCookieName() {
        return this.getString(Key.I18N_COOKIE_NAME, Default.I18N_COOKIE_NAME.toString());
    }

    public boolean isFlashCookieSecure() {
        return this.isSessionCookieSecure();
    }

    public String getApplicationLanguage() {
        return this.getString(Key.APPLICATION_LANGUAGE, Default.APPLICATION_LANGUAGE.toString());
    }

    public boolean isSchedulerAutostart() {
        return this.getBoolean(Key.SCHEDULER_AUTOSTART, Default.SCHEDULER_AUTOSTART.toBoolean());
    }

    public String getApplicationAdminUsername() {
        return this.getString(Key.APPLICATION_ADMIN_USERNAME);
    }

    public String getApplicationAdminPassword() {
        return this.getString(Key.APPLICATION_ADMIN_PASSWORD);
    }

    public String getSchedulerPackage() {
        return this.getString(Key.SCHEDULER_PACKAGE, Default.SCHEDULER_PACKAGE.toString());
    }

    public long getAuthenticationCookieRememberExpires() {
        return this.getLong(Key.AUTHENTICATION_COOKIE_REMEMBER_EXPIRES, Default.AUTHENTICATION_COOKIE_REMEMBER_EXPIRES.toLong());
    }

    public int getApplicationThreadpool() {
        return this.getInt(Key.APPLICATION_THREADPOOL, Default.APPLICATION_THREADPOOL.toInt());
    }

    public String getApplicationController() {
        return this.getString(Key.APPLICATION_CONTROLLER, Default.APPLICATION_CONTROLLER.toString());
    }

    public String getApplicationTemplateEngine() {
        return this.getString(Key.APPLICATION_TEMPLATEENGINE, Default.APPLICATION_TEMPLATEENGINE.toString());
    }

    public boolean isApplicationMinifyJS() {
        return this.getBoolean(Key.APPLICATION_MINIFY_JS, Default.APPLICATION_MINIFY_JS.toBoolean());
    }

    public boolean isApplicationMinifyCSS() {
        return this.getBoolean(Key.APPLICATION_MINIFY_CSS, Default.APPLICATION_MINIFY_CSS.toBoolean());
    }

    public boolean isApplicationAdminEnable() {
        return this.getBoolean(Key.APPLICATION_ADMIN_ENABLE, Default.APPLICATION_ADMIN_ENABLE.toBoolean());
    }

    public String getSmtpHost() {
        return this.getString(Key.SMTP_HOST, Default.SMTP_HOST.toString());
    }

    public int getSmtpPort() {
        return this.getInt(Key.SMTP_PORT, Default.SMTP_PORT.toInt());
    }

    public String getSmtpUsername() {
        return this.getString(Key.SMTP_USERNAME, null);
    }

    public String getSmtpPassword() {
        return this.getString(Key.SMTP_PASSWORD, null);
    }

    public String getSmtpFrom() {
        return this.getString(Key.SMTP_FROM, Default.SMTP_FROM.toString());
    }

    public String getConnectorHttpHost() {
        return this.getString(Key.CONNECTOR_HTTP_HOST, null);
    }

    public int getConnectorHttpPort() {
        return this.getInt(Key.CONNECTOR_HTTP_PORT, 0);
    }

    public String getConnectorAjpHost() {
        return this.getString(Key.CONNECTOR_AJP_HOST, null);
    }

    public int getConnectorAjpPort() {
        return this.getInt(Key.CONNECTOR_AJP_PORT, 0);
    }

    public boolean isCacheCluserEnable() {
        return this.getBoolean(Key.CACHE_CLUSTER_ENABLE, Default.CACHE_CLUSTER_ENABLE.toBoolean());
    }

    public boolean isMetricsEnable() {
        return this.getBoolean(Key.METRICS_ENABLE, Default.METRICS_ENABLE.toBoolean());
    }

    public int getAuthenticationLock() {
        return this.getInt(Key.AUTHENTICATION_LOCK, Default.AUTHENTICATION_LOCK.toInt());
    }

    public String getCacheClusterUrl() {
        return this.getString(Key.CACHE_CLUSTER_URL, null);
    }

    public long getUndertowMaxEntitySize() {
        return this.getLong(Key.UNDERTOW_MAX_ENTITY_SIZE, Default.UNDERTOW_MAX_ENTITY_SIZE.toLong());
    }

    public String getSessionCookieSecret() {
        return this.getString(Key.SESSION_COOKIE_SECRET, this.getApplicationSecret());
    }

    public String getAuthenticationCookieSecret() {
        return this.getString(Key.AUTHENTICATION_COOKIE_SECRET, this.getApplicationSecret());
    }

    public String getFlashCookieSecret() {
        return this.getString(Key.FLASH_COOKIE_SECRET, this.getApplicationSecret());
    }

    public boolean isSchedulerEnabled() {
        return this.getBoolean(Key.SCHEDULER_ENABLE, Default.SCHEDULER_ENABLE.toBoolean());
    }

    public String getApplicationAdminSecret() {
        return this.getString(Key.APPLICATION_ADMIN_SECRET, null);
    }

    public boolean isSmtpDebug() {
        return this.getBoolean(Key.SMTP_DEBUG, Default.SMTP_DEBUG.toBoolean());
    }

    public boolean isCorsEnable() {
        return this.getBoolean(Key.CORS_ENABLE, Default.CORS_ENABLE.toBoolean());
    }

    public Pattern getCorsUrlPattern() {
        if (this.corsUrl == null) {
            this.corsUrl = Pattern.compile((String)this.getString(Key.CORS_URLPATTERN, Default.CORS_URLPATTERN.toString()));
        }
        return this.corsUrl;
    }

    public Pattern getCorsAllowOrigin() {
        if (this.corsAllowOrigin == null) {
            this.corsAllowOrigin = Pattern.compile((String)this.getString(Key.CORS_ALLOWORIGIN, Default.CORS_ALLOWORIGIN.toString()));
        }
        return this.corsAllowOrigin;
    }

    public String getCorsHeadersAllowCredentials() {
        return this.getString(Key.CORS_HEADERS_ALLOWCREDENTIALS, Default.CORS_HEADERS_ALLOWCREDENTIALS.toString());
    }

    public String getCorsHeadersAllowHeaders() {
        return this.getString(Key.CORS_HEADERS_ALLOWHEADERS, Default.CORS_HEADERS_ALLOWHEADERS.toString());
    }

    public String getCorsHeadersAllowMethods() {
        return this.getString(Key.CORS_HEADERS_ALLOWMETHODS, Default.CORS_HEADERS_ALLOWMETHODS.toString());
    }

    public String getCorsHeadersExposeHeaders() {
        return this.getString(Key.CORS_HEADERS_EXPOSEHEADERS, Default.CORS_HEADERS_EXPOSEHEADERS.toString());
    }

    public String getCorsHeadersMaxAge() {
        return this.getString(Key.CORS_HEADERS_MAXAGE, Default.CORS_HEADERS_MAXAGE.toString());
    }

    public String getMongoHost() {
        return this.getString(Key.PERSISTENCE_MONGO_HOST, Default.PERSISTENCE_MONGO_HOST.toString());
    }

    public int getMongoPort() {
        return this.getInt(Key.PERSISTENCE_MONGO_PORT, Default.PERSISTENCE_MONGO_PORT.toInt());
    }

    public String getMongoUsername() {
        return this.getString(Key.PERSISTENCE_MONGO_USERNAME, null);
    }

    public String getMongoPassword() {
        return this.getString(Key.PERSISTENCE_MONGO_PASSWORD, null);
    }

    public String getMongoAuthDB() {
        return this.getString(Key.PERSISTENCE_MONGO_AUTHDB, null);
    }

    public boolean isMongoAuth() {
        return this.getBoolean(Key.PERSISTENCE_MONGO_AUTH, Default.PERSISTENCE_MONGO_AUTH.toBoolean());
    }

    public String getMongoPackage() {
        return this.getString(Key.PERSISTENCE_MONGO_PACKAGE, Default.PERSISTENCE_MONGO_PACKAGE.toString());
    }

    public String getMongoDbName() {
        return this.getString(Key.PERSISTENCE_MONGO_DBNAME, Default.PERSISTENCE_MONGO_DBNAME.toString());
    }

    public boolean isMongoEmbedded() {
        return this.getBoolean(Key.PERSISTENCE_MONGO_EMBEDDED, Default.PERSISTENCE_MONGO_EMBEDDED.toBoolean());
    }

    public boolean isSessionCookieExpires() {
        return this.getBoolean(Key.SESSION_COOKIE_EXPIRES, Default.SESSION_COOKIE_EXPIRES.toBoolean());
    }

    public boolean isAuthenticationCookieExpires() {
        return this.getBoolean(Key.AUTHENTICATION_COOKIE_EXPIRES, Default.AUTHENTICATION_COOKIE_EXPIRES.toBoolean());
    }

    public long getAuthenticationCookieTokenExpires() {
        return this.getLong(Key.AUTHENTICATION_COOKIE_TOKEN_EXPIRES, Default.AUTHENTICATION_COOKIE_TOKEN_EXPIRES.toLong());
    }

    public boolean isSmtpAuthentication() {
        return this.getBoolean(Key.SMTP_AUTHENTICATION, Default.SMTP_AUTHENTICATION.toBoolean());
    }

    public String getSmtpProtocol() {
        return this.getString(Key.SMTP_PROTOCOL, Default.SMTP_PROTOCOL.toString());
    }

    public boolean isApplicationAdminHealthEnable() {
        return this.getBoolean(Key.APPLICATION_ADMIN_HEALTH_ENABLE, Default.APPLICATION_ADMIN_HEALTH_ENABLE.toBoolean());
    }

    public String getApplicationAdminHealthToken() {
        return this.getString(Key.APPLICATION_ADMIN_HEALTH_TOKEN, null);
    }
}

