/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.inject.Singleton;
import io.mangoo.cache.CacheProvider;
import io.mangoo.core.Application;
import io.mangoo.exceptions.MangooSchedulerException;
import io.mangoo.interfaces.MangooBootstrap;
import io.mangoo.scheduler.Scheduler;
import io.mangoo.services.ConcurrentService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class Shutdown
extends Thread {
    private static final Logger LOG = LogManager.getLogger(Shutdown.class);

    @Override
    public void run() {
        Shutdown.invokeLifecycle();
        Shutdown.stopUndertow();
        Shutdown.stopScheduler();
        Shutdown.stopExecutionManager();
        Shutdown.closeCaches();
    }

    private static void invokeLifecycle() {
        Application.getInstance(MangooBootstrap.class).applicationStopped();
    }

    private static void stopExecutionManager() {
        Application.getInstance(ConcurrentService.class).shutdown();
    }

    private static void stopScheduler() {
        Scheduler scheduler = Application.getInstance(Scheduler.class);
        try {
            if (scheduler != null && scheduler.isInitialize()) {
                scheduler.shutdown();
            }
        }
        catch (MangooSchedulerException mangooSchedulerException) {
            LOG.error("Failed to stop scheduler during application shutdown", (Throwable)mangooSchedulerException);
        }
    }

    private static void stopUndertow() {
        Application.stopUndertow();
    }

    private static void closeCaches() {
        Application.getInstance(CacheProvider.class).close();
    }
}

