/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.crypto;

import com.google.inject.Inject;
import io.mangoo.core.Config;
import io.mangoo.enums.Required;
import io.mangoo.exceptions.MangooEncryptionException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.RegExUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.engines.AESLightEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Crypto {
    private static final Logger LOG = LogManager.getLogger(Crypto.class);
    private final PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESLightEngine()));
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();
    private static final String TRANSFORMATION = "RSA/None/OAEPWITHSHA-512ANDMGF1PADDING";
    private static final String ALGORITHM = "RSA";
    private static final int KEYLENGTH = 2048;
    private static final int KEYINDEX_START = 0;
    private static final int MAX_KEY_LENGTH = 32;
    private Config config;

    @Inject
    public Crypto(Config config) {
        this.config = Objects.requireNonNull(config, Required.CONFIG.toString());
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public String decrypt(String string) {
        Objects.requireNonNull(string, Required.ENCRYPTED_TEXT.toString());
        return this.decrypt(string, this.getSizedSecret(this.config.getApplicationSecret()));
    }

    public String decrypt(String string, String string2) {
        Objects.requireNonNull(string, Required.ENCRYPTED_TEXT.toString());
        Objects.requireNonNull(string2, Required.KEY.toString());
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)new KeyParameter(this.getSizedSecret(string2).getBytes(StandardCharsets.UTF_8)));
        this.paddedBufferedBlockCipher.init(false, (CipherParameters)parametersWithRandom);
        return new String(this.cipherData(base64Decoder.decode(string)), StandardCharsets.UTF_8);
    }

    public String encrypt(String string) {
        Objects.requireNonNull(string, Required.PLAIN_TEXT.toString());
        return this.encrypt(string, this.getSizedSecret(this.config.getApplicationSecret()));
    }

    public String encrypt(String string, String string2) {
        Objects.requireNonNull(string, Required.PLAIN_TEXT.toString());
        Objects.requireNonNull(string2, Required.KEY.toString());
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom((CipherParameters)new KeyParameter(this.getSizedSecret(string2).getBytes(StandardCharsets.UTF_8)));
        this.paddedBufferedBlockCipher.init(true, (CipherParameters)parametersWithRandom);
        return new String(base64Encoder.encode(this.cipherData(string.getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8);
    }

    private byte[] cipherData(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = new byte[this.paddedBufferedBlockCipher.getOutputSize(byArray.length)];
            int n = this.paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
            int n2 = this.paddedBufferedBlockCipher.doFinal(byArray3, n);
            byArray2 = new byte[n + n2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        }
        catch (CryptoException cryptoException) {
            LOG.error("Failed to encrypt/decrypt data array", (Throwable)cryptoException);
        }
        return byArray2;
    }

    public String getSizedSecret(String string) {
        Objects.requireNonNull(string, Required.SECRET.toString());
        String string2 = RegExUtils.replaceAll((String)string, (String)"[^\\x00-\\x7F]", (String)"");
        return string2.length() < 32 ? string2 : string2.substring(0, 32);
    }

    public KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
            keyPairGenerator.initialize(2048);
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error("Failed to create publi/private key pair", (Throwable)noSuchAlgorithmException);
        }
        return keyPair;
    }

    public byte[] encrypt(byte[] byArray, PublicKey publicKey) throws MangooEncryptionException {
        Objects.requireNonNull(byArray, Required.PLAIN_TEXT.toString());
        Objects.requireNonNull(byArray, Required.PUBLIC_KEY.toString());
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, publicKey);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            throw new MangooEncryptionException("Failed to encrypt clear text with public key", generalSecurityException);
        }
        return byArray2;
    }

    public String encrypt(String string, PublicKey publicKey) throws MangooEncryptionException {
        Objects.requireNonNull(string, Required.PLAIN_TEXT.toString());
        Objects.requireNonNull(string, Required.PUBLIC_KEY.toString());
        String string2 = null;
        try {
            byte[] byArray = this.encrypt(string.getBytes(StandardCharsets.UTF_8), publicKey);
            string2 = this.encodeBase64(byArray);
        }
        catch (MangooEncryptionException mangooEncryptionException) {
            throw new MangooEncryptionException("Failed to encrypt clear text with public key", mangooEncryptionException);
        }
        return string2;
    }

    public byte[] decrypt(byte[] byArray, PrivateKey privateKey) throws MangooEncryptionException {
        Objects.requireNonNull(byArray, Required.ENCRYPTED_TEXT.toString());
        Objects.requireNonNull(byArray, Required.PRIVATE_KEY.toString());
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, privateKey);
            byArray2 = cipher.doFinal(byArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            throw new MangooEncryptionException("Failed to decrypt encrypted text with private key", generalSecurityException);
        }
        return byArray2;
    }

    public String decrypt(String string, PrivateKey privateKey) throws MangooEncryptionException {
        Objects.requireNonNull(string, Required.ENCRYPTED_TEXT.toString());
        Objects.requireNonNull(string, Required.PRIVATE_KEY.toString());
        String string2 = null;
        try {
            byte[] byArray = this.decrypt(this.decodeBase64(string), privateKey);
            string2 = new String(byArray, StandardCharsets.UTF_8);
        }
        catch (MangooEncryptionException mangooEncryptionException) {
            throw new MangooEncryptionException("Failed to decrypt encrypted text with private key", mangooEncryptionException);
        }
        return string2;
    }

    public String getKeyAsString(Key key) {
        Objects.requireNonNull(key, Required.KEY.toString());
        return this.encodeBase64(key.getEncoded());
    }

    public PrivateKey getPrivateKeyFromString(String string) throws MangooEncryptionException {
        Objects.requireNonNull(string, Required.KEY.toString());
        try {
            return KeyFactory.getInstance(ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(this.decodeBase64(string)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new MangooEncryptionException("Failed to get private key from string", generalSecurityException);
        }
    }

    public PublicKey getPublicKeyFromString(String string) throws MangooEncryptionException {
        Objects.requireNonNull(string, Required.KEY.toString());
        try {
            return KeyFactory.getInstance(ALGORITHM).generatePublic(new X509EncodedKeySpec(this.decodeBase64(string)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new MangooEncryptionException("Failed to get pulbic key from string", generalSecurityException);
        }
    }

    private String encodeBase64(byte[] byArray) {
        Objects.requireNonNull(byArray, Required.BYTES.toString());
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])byArray);
    }

    private byte[] decodeBase64(String string) {
        Objects.requireNonNull(string, Required.PLAIN_TEXT.toString());
        return org.apache.commons.codec.binary.Base64.decodeBase64((String)string);
    }
}

