/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.email;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.core.Config;
import io.mangoo.enums.Required;
import io.mangoo.exceptions.MangooMailerException;
import java.util.Objects;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.mailer.MailerBuilder;
import org.simplejavamail.mailer.internal.MailerRegularBuilderImpl;

@Singleton
public class MailEvent {
    private Mailer mailer;

    @Inject
    public MailEvent(Config config) {
        Objects.requireNonNull(config, Required.CONFIG.toString());
        MailerRegularBuilderImpl mailerRegularBuilderImpl = MailerBuilder.withDebugLogging((Boolean)config.isSmtpDebug()).withSMTPServerHost(config.getSmtpHost()).withSMTPServerPort(Integer.valueOf(config.getSmtpPort()));
        if (config.isSmtpAuthentication()) {
            mailerRegularBuilderImpl.withSMTPServerUsername(config.getSmtpUsername());
            mailerRegularBuilderImpl.withSMTPServerPassword(config.getSmtpPassword());
        }
        if ("smtps".equalsIgnoreCase(config.getSmtpProtocol())) {
            mailerRegularBuilderImpl.withTransportStrategy(TransportStrategy.SMTPS);
        } else if ("smtptls".equalsIgnoreCase(config.getSmtpProtocol())) {
            mailerRegularBuilderImpl.withTransportStrategy(TransportStrategy.SMTP_TLS);
        } else {
            mailerRegularBuilderImpl.withTransportStrategy(TransportStrategy.SMTP);
        }
        this.mailer = mailerRegularBuilderImpl.buildMailer();
    }

    public void send(Email email) throws MangooMailerException {
        try {
            this.mailer.sendMail(email, true);
        }
        catch (MailException mailException) {
            throw new MangooMailerException((Exception)((Object)mailException));
        }
    }
}

