/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.i18n;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Messages
implements Serializable {
    private static final long serialVersionUID = 7560110796880143546L;
    private Map<String, String> defaults = Default.getMessages();
    private transient ResourceBundle bundle = ResourceBundle.getBundle(Default.BUNDLE_NAME.toString(), Locale.getDefault());

    public void reload(Locale locale) {
        this.bundle = ResourceBundle.getBundle(Default.BUNDLE_NAME.toString(), locale);
    }

    public String get(String string) {
        return this.bundle.getString(string);
    }

    @SuppressFBWarnings(justification="Key access as intended", value={"MUI_CONTAINSKEY_BEFORE_GET"})
    public String get(String string, Object ... objectArray) {
        if (this.bundle.containsKey(string)) {
            return MessageFormat.format(this.bundle.getString(string), objectArray);
        }
        if (this.defaults.containsKey(string)) {
            return MessageFormat.format(this.defaults.get(string), objectArray);
        }
        return "";
    }

    public String get(Key key, Object ... objectArray) {
        return this.get(key.toString(), objectArray);
    }
}

