/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.persistence;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import dev.morphia.DeleteOptions;
import dev.morphia.Morphia;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import io.mangoo.core.Config;
import io.mangoo.enums.Required;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;

@Singleton
public class Datastore {
    private static final Logger LOG = LogManager.getLogger(Datastore.class);
    private dev.morphia.Datastore datastore;
    private MongoClient mongoClient;
    private Config config;

    @Inject
    public Datastore(Config config) {
        this.config = Objects.requireNonNull(config, Required.CONFIG.toString());
        this.connect();
    }

    public dev.morphia.Datastore getDatastore() {
        return this.datastore;
    }

    public dev.morphia.Datastore query() {
        return this.datastore;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    private void connect() {
        this.mongoClient = MongoClients.create((String)this.getConnectionString());
        this.datastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)this.config.getMongoDbName());
        this.datastore.getMapper().mapPackage(this.config.getMongoPackage());
        LOG.info("Created MongoClient connected to {}:{} with credentials = {}", (Object)this.config.getMongoHost(), (Object)this.config.getMongoPort(), (Object)this.config.isMongoAuth());
        LOG.info("Mapped Morphia models of package '{}' and created Morphia Datastore conntected to database '{}'", (Object)this.config.getMongoPackage(), (Object)this.config.getMongoDbName());
    }

    private String getConnectionString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mongodb://");
        if (this.config.isMongoAuth()) {
            stringBuilder.append(this.config.getMongoUsername()).append(':').append(this.config.getMongoPassword()).append('@');
        }
        stringBuilder.append(this.config.getMongoHost()).append(':').append(this.config.getMongoPort());
        if (this.config.isMongoAuth()) {
            stringBuilder.append("/?authSource=").append(this.config.getMongoAuthDB());
        }
        return stringBuilder.toString();
    }

    public void ensureIndexes() {
        this.datastore.ensureIndexes();
    }

    public void ensureCaps() {
        this.datastore.ensureCaps();
    }

    public <T> T findById(String string, Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to find an object by id, but given class is null");
        Preconditions.checkNotNull((Object)string, (Object)"Tryed to find an object by id, but given id is null");
        return (T)this.datastore.find(clazz).filter(new Filter[]{Filters.eq((String)"_id", (Object)new ObjectId(string))}).first();
    }

    public <T> List<T> findAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to get all morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).iterator().toList();
    }

    public <T> long countAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to count all a morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).count();
    }

    public void save(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to save a morphia object, but a given object is null");
        this.datastore.save(object);
    }

    public void delete(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to delete a morphia object, but given object is null");
        this.datastore.delete(object);
    }

    public <T> void deleteAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to delete list of mapped morphia objects, but given class is null");
        this.datastore.find(clazz).delete(new DeleteOptions().multi(true));
    }

    public void dropDatabase() {
        this.datastore.getDatabase().drop();
    }
}

