/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing;

import com.google.common.net.MediaType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.enums.Header;
import io.mangoo.enums.Required;
import io.mangoo.utils.JsonUtils;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Response {
    private static final Logger LOG = LogManager.getLogger(Response.class);
    private final Map<HttpString, String> headers = new HashMap<HttpString, String>();
    private final Map<String, Object> content = new HashMap<String, Object>();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private String redirectTo;
    private String contentType = MediaType.HTML_UTF_8.withoutParameters().toString();
    private String charset = StandardCharsets.UTF_8.name();
    private String body = "";
    private String template;
    private String binaryFileName;
    private byte[] binaryContent;
    private boolean endResponse;
    private boolean binary;
    private boolean rendered;
    private boolean redirect;
    private boolean unrendered;
    private int statusCode = 200;

    public Response() {
    }

    private Response(int n) {
        this.statusCode = n;
        this.rendered = true;
    }

    private Response(String string) {
        Objects.requireNonNull(string, Required.REDIRECT_TO.toString());
        this.redirect = true;
        this.rendered = false;
        this.redirectTo = string;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getBody() {
        return this.body;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies);
    }

    public byte[] getBinaryContent() {
        return (byte[])this.binaryContent.clone();
    }

    public String getTemplate() {
        return this.template;
    }

    public String getBinaryFileName() {
        return this.binaryFileName;
    }

    public Map<String, Object> getContent() {
        return this.content;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public boolean isEndResponse() {
        return this.endResponse;
    }

    public boolean isUnrendered() {
        return this.unrendered;
    }

    public String getRedirectTo() {
        return this.redirectTo;
    }

    public Map<HttpString, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(HttpString httpString) {
        Objects.requireNonNull(httpString, Required.HEADER.toString());
        return this.headers.get(httpString);
    }

    public static Response withOk() {
        return new Response(200);
    }

    public static Response withCreated() {
        return new Response(201);
    }

    public static Response withNotFound() {
        return new Response(404);
    }

    public static Response withForbidden() {
        return new Response(403);
    }

    public static Response withUnauthorized() {
        return new Response(401);
    }

    public static Response withBadRequest() {
        return new Response(400);
    }

    public static Response withInternalServerError() {
        return new Response(500);
    }

    public static Response withStatusCode(int n) {
        return new Response(n);
    }

    public static Response withRedirect(String string) {
        Objects.requireNonNull(string, Required.REDIRECT_TO.toString());
        return new Response(string);
    }

    public Response andTemplate(String string) {
        Objects.requireNonNull(string, Required.TEMPLATE.toString());
        this.template = string;
        return this;
    }

    public Response andContentType(String string) {
        Objects.requireNonNull(string, Required.CONTENT_TYPE.toString());
        this.contentType = string;
        this.headers.put(Header.CONTENT_TYPE.toHttpString(), string);
        return this;
    }

    public Response andCharset(String string) {
        Objects.requireNonNull(string, Required.CHARSET.toString());
        this.charset = string;
        return this;
    }

    public Response andContent(String string, Object object) {
        Objects.requireNonNull(string, Required.NAME.toString());
        this.content.put(string, object);
        return this;
    }

    public Response andBody(String string) {
        this.body = string;
        this.rendered = false;
        return this;
    }

    public Response andUnrenderedBody() {
        this.rendered = false;
        this.unrendered = true;
        return this;
    }

    public Response andCookie(Cookie cookie) {
        Objects.requireNonNull(cookie, Required.COOKIE.toString());
        this.cookies.add(cookie);
        return this;
    }

    public Response andJsonBody(Object object) {
        Objects.requireNonNull(object, Required.JSON_OBJECT.toString());
        this.contentType = MediaType.JSON_UTF_8.withoutParameters().toString();
        this.body = JsonUtils.toJson(object);
        this.rendered = false;
        return this;
    }

    @SuppressFBWarnings(justification="null check of file on entry point of method", value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Response andBinaryFile(Path path) {
        Objects.requireNonNull(path, Required.FILE.toString());
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            this.binaryFileName = path.getFileName().toString();
            this.binaryContent = IOUtils.toByteArray((InputStream)inputStream);
            this.binary = true;
            this.rendered = false;
        }
        catch (IOException iOException) {
            LOG.error("Failed to handle binary file", (Throwable)iOException);
        }
        return this;
    }

    public Response andBinaryContent(byte[] byArray) {
        Objects.requireNonNull(byArray, Required.CONTENT.toString());
        this.binaryContent = (byte[])byArray.clone();
        this.binary = true;
        this.rendered = false;
        return this;
    }

    public Response andTextBody(String string) {
        this.contentType = MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString();
        this.body = string;
        this.rendered = false;
        return this;
    }

    public Response andEmptyBody() {
        this.contentType = MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString();
        this.rendered = false;
        return this;
    }

    public Response andHeader(HttpString httpString, String string) {
        Objects.requireNonNull(httpString, Required.KEY.toString());
        this.headers.put(httpString, string);
        return this;
    }

    public Response andContent(Map<String, Object> map) {
        Objects.requireNonNull(map, Required.CONTENT.toString());
        this.content.putAll(map);
        return this;
    }

    public Response andHeaders(Map<HttpString, String> map) {
        Objects.requireNonNull(map, Required.HEADERS.toString());
        this.headers.putAll(map);
        return this;
    }

    public Response andEndResponse() {
        this.endResponse = true;
        return this;
    }
}

