/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import com.google.inject.Inject;
import com.google.re2j.Pattern;
import io.mangoo.enums.Required;
import io.mangoo.enums.Validation;
import io.mangoo.i18n.Messages;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class Validator
implements Serializable {
    private static final long serialVersionUID = -2467664448802191044L;
    private final Map<String, String> errors = new HashMap<String, String>();
    protected Map<String, String> values = new HashMap<String, String>();
    @Inject
    private Messages messages;

    public boolean hasError(String string) {
        return this.errors.containsKey(string);
    }

    public String getError(String string) {
        return this.hasError(string) ? this.errors.get(string) : "";
    }

    public void expectValue(String string) {
        this.expectValue(string, this.messages.get(Validation.REQUIRED_KEY.name(), string));
    }

    public void expectValue(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isBlank((CharSequence)StringUtils.trimToNull((String)string3))) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.REQUIRED_KEY.name(), string)));
        }
    }

    public void expectMin(String string, double d) {
        this.expectMin(string, d, this.messages.get(Validation.MIN_KEY.name(), string, d));
    }

    public void expectMin(String string, double d, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            if (Double.parseDouble(string3) < d) {
                this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.MIN_KEY.name(), string, d)));
            }
        } else if ((double)string3.length() < d) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.MIN_KEY.name(), string, d)));
        }
    }

    public void expectMax(String string, double d) {
        this.expectMax(string, d, this.messages.get(Validation.MAX_KEY.name(), string, d));
    }

    public void expectNumeric(String string) {
        this.expectNumeric(string, this.messages.get(Validation.NUMERIC_KEY.name(), string));
    }

    public void expectNumeric(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!StringUtils.isNumeric((CharSequence)string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.NUMERIC_KEY.name(), string)));
        }
    }

    public void expectMax(String string, double d, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            if (Double.parseDouble(string3) > d) {
                this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.MAX_KEY.name(), string, d)));
            }
        } else if ((double)string3.length() > d) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.MAX_KEY.name(), string, d)));
        }
    }

    public void expectExactMatch(String string, String string2) {
        this.expectExactMatch(string, string2, this.messages.get(Validation.EXACT_MATCH_KEY.name(), string, string2));
    }

    public void expectExactMatch(String string, String string2, String string3) {
        String string4 = Optional.ofNullable(this.get(string)).orElse("");
        String string5 = Optional.ofNullable(this.get(string2)).orElse("");
        if (StringUtils.isBlank((CharSequence)string4) && StringUtils.isBlank((CharSequence)string5) || StringUtils.isNotBlank((CharSequence)string4) && !string4.equals(string5)) {
            this.addError(string, Optional.ofNullable(string3).orElse(this.messages.get(Validation.EXACT_MATCH_KEY.name(), string, string2)));
        }
    }

    public void expectMatch(String string, String string2) {
        this.expectMatch(string, string2, this.messages.get(Validation.MATCH_KEY.name(), string, string2));
    }

    public void expectMatch(String string, String string2, String string3) {
        String string4 = Optional.ofNullable(this.get(string)).orElse("");
        String string5 = Optional.ofNullable(this.get(string2)).orElse("");
        if (StringUtils.isBlank((CharSequence)string4) && StringUtils.isBlank((CharSequence)string5) || StringUtils.isNotBlank((CharSequence)string4) && !string4.equalsIgnoreCase(string5)) {
            this.addError(string, Optional.ofNullable(string3).orElse(this.messages.get(Validation.MATCH_KEY.name(), string, string2)));
        }
    }

    public void expectMatch(String string, List<String> list) {
        this.expectMatch(string, this.messages.get(Validation.MATCH_VALUES_KEY.name(), string), list);
    }

    public void expectMatch(String string, String string2, List<String> list) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!list.contains(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.MATCH_VALUES_KEY.name(), string)));
        }
    }

    public void expectEmail(String string) {
        this.expectEmail(string, this.messages.get(Validation.EMAIL_KEY.name(), string));
    }

    public void expectEmail(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!EmailValidator.getInstance().isValid(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.EMAIL_KEY.name(), string)));
        }
    }

    public void expectIpv4(String string) {
        this.expectIpv4(string, this.messages.get(Validation.IPV4_KEY.name(), string));
    }

    public void expectIpv4(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!InetAddressValidator.getInstance().isValidInet4Address(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.IPV4_KEY.name(), string)));
        }
    }

    public void expectDomainName(String string) {
        this.expectDomainName(string, this.messages.get(Validation.IPV4_KEY.name(), string));
    }

    public void expectDomainName(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!DomainValidator.getInstance().isValid(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.DOMAIN_NAME_KEY.name(), string)));
        }
    }

    public void expectIpv6(String string) {
        this.expectIpv6(string, this.messages.get(Validation.IPV6_KEY.name(), string));
    }

    public void expectIpv6(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!InetAddressValidator.getInstance().isValidInet6Address(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.IPV6_KEY.name(), string)));
        }
    }

    public void expectRange(String string, int n, int n2) {
        this.expectRange(string, n, n2, this.messages.get(Validation.RANGE_KEY.name(), string, n, n2));
    }

    public void expectRange(String string, int n, int n2, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (StringUtils.isNumeric((CharSequence)string3)) {
            double d = Double.parseDouble(string3);
            if (d < (double)n || d > (double)n2) {
                this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.RANGE_KEY.name(), string, n, n2)));
            }
        } else if (string3.length() < n || string3.length() > n2) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.RANGE_KEY.name(), string, n, n2)));
        }
    }

    public void expectRegex(String string, Pattern pattern) {
        this.expectRegex(string, pattern, this.messages.get(Validation.REGEX_KEY.name(), string));
    }

    public void expectRegex(String string, Pattern pattern, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!pattern.matcher((CharSequence)string3).matches()) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.REGEX_KEY.name(), string)));
        }
    }

    public void expectUrl(String string) {
        this.expectUrl(string, this.messages.get(Validation.URL_KEY.name(), string));
    }

    public void expectUrl(String string, String string2) {
        String string3 = Optional.ofNullable(this.get(string)).orElse("");
        if (!UrlValidator.getInstance().isValid(string3)) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.URL_KEY.name(), string)));
        }
    }

    public void validateTrue(boolean bl, String string, String string2) {
        if (!bl) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.TRUE_KEY.name(), string)));
        }
    }

    public void validateTrue(boolean bl, String string) {
        this.validateTrue(bl, string, this.messages.get(Validation.TRUE_KEY.name(), string));
    }

    public void validateFalse(boolean bl, String string, String string2) {
        if (bl) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.FALSE_KEY.name(), string)));
        }
    }

    public void validateFalse(boolean bl, String string) {
        this.validateFalse(bl, string, this.messages.get(Validation.FALSE_KEY.name(), string));
    }

    public void validateNotNull(Object object, String string, String string2) {
        if (object == null) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.NOTNULL_KEY.name(), string)));
        }
    }

    public void validateNotNull(Object object, String string) {
        this.validateNotNull(object, string, this.messages.get(Validation.NOTNULL_KEY.name(), string));
    }

    public void validateNull(Object object, String string, String string2) {
        if (object != null) {
            this.addError(string, Optional.ofNullable(string2).orElse(this.messages.get(Validation.NULL_KEY.name(), string)));
        }
    }

    public void validateNull(Object object, String string) {
        this.validateNull(object, string, this.messages.get(Validation.NULL_KEY.name(), string));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public String get(String string) {
        Objects.requireNonNull(string, Required.KEY.toString());
        return this.values.get(string);
    }

    private void addError(String string, String string2) {
        Objects.requireNonNull(string, Required.NAME.toString());
        Objects.requireNonNull(string2, Required.MESSAGE.toString());
        if (!this.errors.containsKey(string)) {
            this.errors.put(string, string2);
        }
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void setValues(Map<String, String> map) {
        this.values = map;
    }

    public void addValue(String string, String string2) {
        this.values.put(string, string2);
    }

    public boolean isValid() {
        return !this.hasErrors();
    }

    public void invalidate() {
        this.errors.put("", "");
    }
}

