/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import io.mangoo.core.Application;
import io.mangoo.core.Server;
import io.mangoo.enums.Header;
import io.mangoo.enums.Required;
import io.mangoo.interfaces.MangooAuthorizationService;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Authentication;
import io.mangoo.routing.handlers.FormHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AuthorizationHandler
implements HttpHandler {
    private MangooAuthorizationService authorizationService;

    @Inject
    public AuthorizationHandler(MangooAuthorizationService mangooAuthorizationService) {
        this.authorizationService = Objects.requireNonNull(mangooAuthorizationService, Required.AUTHORIZATION_SERVICE.toString());
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        if (attachment.hasAuthorization()) {
            Authentication authentication = attachment.getAuthentication();
            if (authentication != null && authentication.isValid()) {
                String string;
                String string2;
                String string3 = authentication.getSubject();
                if (this.isNotBlank(string3, string2 = attachment.getControllerAndMethod(), string = RequestUtils.getOperation(httpServerExchange.getRequestMethod())) && this.authorizationService.validAuthorization(string3, string2, string)) {
                    this.nextHandler(httpServerExchange);
                } else {
                    this.endRequest(httpServerExchange);
                }
            } else {
                this.endRequest(httpServerExchange);
            }
        } else {
            this.nextHandler(httpServerExchange);
        }
    }

    private boolean isNotBlank(String string, String string2, String string3) {
        return StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2) && StringUtils.isNotBlank((CharSequence)string3);
    }

    private void endRequest(HttpServerExchange httpServerExchange) {
        httpServerExchange.setStatusCode(401);
        Server.headers().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> httpServerExchange.getResponseHeaders().add(((Header)((Object)((Object)entry.getKey()))).toHttpString(), (String)entry.getValue()));
        httpServerExchange.endExchange();
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(FormHandler.class).handleRequest(httpServerExchange);
    }
}

