/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.common.net.MediaType;
import io.mangoo.core.Server;
import io.mangoo.enums.Header;
import io.mangoo.enums.Required;
import io.mangoo.routing.Response;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class BinaryHandler
implements HttpHandler {
    private Response response;

    public BinaryHandler withResponse(Response response) {
        if (this.response == null) {
            this.response = Objects.requireNonNull(response, Required.RESPONSE.toString());
        }
        return this;
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        httpServerExchange.startBlocking();
        httpServerExchange.setStatusCode(this.response.getStatusCode());
        Server.headers().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> httpServerExchange.getResponseHeaders().add(((Header)((Object)((Object)entry.getKey()))).toHttpString(), (String)entry.getValue()));
        httpServerExchange.getResponseHeaders().put(Header.CONTENT_TYPE.toHttpString(), MediaType.OCTET_STREAM.withoutParameters().toString());
        httpServerExchange.getResponseHeaders().put(Header.CONTENT_DISPOSITION.toHttpString(), "inline; filename=" + this.response.getBinaryFileName());
        this.response.getHeaders().forEach((httpString, string) -> httpServerExchange.getResponseHeaders().add(httpString, string));
        httpServerExchange.getOutputStream().write(this.response.getBinaryContent());
    }
}

