/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.Required;
import io.mangoo.routing.handlers.ResponseHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CorsHandler
implements HttpHandler {
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    private static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private Config config;

    @Inject
    public CorsHandler(Config config) {
        this.config = Objects.requireNonNull(config, Required.CONFIG.toString());
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        if (this.config.isCorsEnable() && this.config.getCorsUrlPattern().matcher((CharSequence)httpServerExchange.getRequestURL()).matches()) {
            this.applyHeader(httpServerExchange);
        }
        this.nextHandler(httpServerExchange);
    }

    private void applyHeader(HttpServerExchange httpServerExchange) {
        String string = this.getOrigin(httpServerExchange);
        if (StringUtils.isNotBlank((CharSequence)string) && this.config.getCorsAllowOrigin().matcher((CharSequence)string).matches()) {
            if (this.doesNotHaveHeader(ACCESS_CONTROL_ALLOW_ORIGIN, httpServerExchange)) {
                this.addHeader(httpServerExchange, ACCESS_CONTROL_ALLOW_ORIGIN, string);
            }
            if (this.doesNotHaveHeader(ACCESS_CONTROL_ALLOW_HEADERS, httpServerExchange)) {
                this.addHeader(httpServerExchange, ACCESS_CONTROL_ALLOW_HEADERS, this.config.getCorsHeadersAllowHeaders());
            }
            if (this.doesNotHaveHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, httpServerExchange)) {
                this.addHeader(httpServerExchange, ACCESS_CONTROL_ALLOW_CREDENTIALS, this.config.getCorsHeadersAllowCredentials());
            }
            if (this.doesNotHaveHeader(ACCESS_CONTROL_ALLOW_METHODS, httpServerExchange)) {
                this.addHeader(httpServerExchange, ACCESS_CONTROL_ALLOW_METHODS, this.config.getCorsHeadersAllowMethods());
            }
            if (this.doesNotHaveHeader(ACCESS_CONTROL_EXPOSE_HEADERS, httpServerExchange)) {
                this.addHeader(httpServerExchange, ACCESS_CONTROL_EXPOSE_HEADERS, this.config.getCorsHeadersExposeHeaders());
            }
            if (this.doesNotHaveHeader(ACCESS_CONTROL_MAX_AGE, httpServerExchange)) {
                this.addHeader(httpServerExchange, ACCESS_CONTROL_MAX_AGE, this.config.getCorsHeadersMaxAge());
            }
        }
    }

    private String getOrigin(HttpServerExchange httpServerExchange) {
        HeaderValues headerValues = httpServerExchange.getRequestHeaders().get("Origin");
        return headerValues == null ? null : headerValues.peekFirst();
    }

    private boolean doesNotHaveHeader(String string, HttpServerExchange httpServerExchange) {
        return httpServerExchange.getResponseHeaders().get(string) == null;
    }

    private void addHeader(HttpServerExchange httpServerExchange, String string, String string2) {
        httpServerExchange.getResponseHeaders().add(HttpString.tryFromString((String)string), string2);
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(ResponseHandler.class).handleRequest(httpServerExchange);
    }
}

