/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import io.mangoo.core.Application;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.handlers.RequestHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Deque;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class FormHandler
implements HttpHandler {
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        if (attachment.getForm() == null) {
            attachment.setForm(this.getForm(httpServerExchange));
        }
        httpServerExchange.putAttachment(RequestUtils.getAttachmentKey(), (Object)attachment);
        this.nextHandler(httpServerExchange);
    }

    protected Form getForm(HttpServerExchange httpServerExchange) throws IOException {
        Form form = Application.getInstance(Form.class);
        if (RequestUtils.isPostPutPatch(httpServerExchange)) {
            block11: {
                FormParserFactory.Builder builder = FormParserFactory.builder();
                builder.setDefaultCharset(StandardCharsets.UTF_8.name());
                try (FormDataParser formDataParser = builder.build().createParser(httpServerExchange);){
                    if (formDataParser == null) break block11;
                    httpServerExchange.startBlocking();
                    FormData formData = formDataParser.parseBlocking();
                    for (String string : formData) {
                        FormData.FormValue formValue;
                        Deque deque = formData.get(string);
                        if (deque == null || (formValue = (FormData.FormValue)deque.element()) == null) continue;
                        if (formValue.isFileItem() && formValue.getFileItem().getFile() != null) {
                            form.addFile(Files.newInputStream(formValue.getFileItem().getFile(), new OpenOption[0]));
                            continue;
                        }
                        if (string.contains("[]")) {
                            String string2 = StringUtils.replace((String)string, (String)"[]", (String)"");
                            Iterator iterator = deque.iterator();
                            while (iterator.hasNext()) {
                                form.addValueList(new HttpString(string2).toString(), ((FormData.FormValue)iterator.next()).getValue());
                            }
                            continue;
                        }
                        form.addValue(new HttpString(string).toString(), formValue.getValue());
                    }
                }
            }
            form.setSubmitted(true);
        }
        return form;
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(RequestHandler.class).handleRequest(httpServerExchange);
    }
}

