/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import com.google.inject.Inject;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.Header;
import io.mangoo.enums.Required;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.handlers.InboundCookiesHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderValues;
import io.undertow.util.LocaleUtils;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class LocaleHandler
implements HttpHandler {
    private Config config;

    @Inject
    public LocaleHandler(Config config) {
        this.config = Objects.requireNonNull(config, Required.CONFIG.toString());
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Locale locale = Locale.forLanguageTag(this.config.getApplicationLanguage());
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        Cookie cookie = (Cookie)httpServerExchange.getRequestCookies().get(this.config.getI18nCookieName());
        if (cookie == null) {
            String string;
            HeaderValues headerValues = httpServerExchange.getRequestHeaders().get(Header.ACCEPT_LANGUAGE.toHttpString());
            if (headerValues != null && StringUtils.isNotBlank((CharSequence)(string = headerValues.element()))) {
                locale = LocaleUtils.getLocaleFromString((String)string);
            }
        } else {
            locale = LocaleUtils.getLocaleFromString((String)cookie.getValue());
        }
        attachment.getMessages().reload(locale);
        attachment.withLocale(locale);
        httpServerExchange.putAttachment(RequestUtils.getAttachmentKey(), (Object)attachment);
        this.nextHandler(httpServerExchange);
    }

    protected void nextHandler(HttpServerExchange httpServerExchange) throws Exception {
        Application.getInstance(InboundCookiesHandler.class).handleRequest(httpServerExchange);
    }
}

