/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import io.mangoo.core.Application;
import io.mangoo.core.Server;
import io.mangoo.enums.Header;
import io.mangoo.routing.Attachment;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.handlers.BinaryHandler;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.apache.commons.lang3.StringUtils;

public class ResponseHandler
implements HttpHandler {
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Attachment attachment = (Attachment)httpServerExchange.getAttachment(RequestUtils.getAttachmentKey());
        Response response = attachment.getResponse();
        if (response.isRedirect()) {
            this.handleRedirectResponse(httpServerExchange, response);
        } else if (response.isBinary()) {
            this.handleBinaryResponse(httpServerExchange, response);
        } else {
            this.handleRenderedResponse(httpServerExchange, response);
        }
        Form form = attachment.getForm();
        if (form != null) {
            form.discard();
        }
    }

    protected void handleBinaryResponse(HttpServerExchange httpServerExchange, Response response) {
        httpServerExchange.dispatch(httpServerExchange.getDispatchExecutor(), (HttpHandler)Application.getInstance(BinaryHandler.class).withResponse(response));
    }

    protected void handleRedirectResponse(HttpServerExchange httpServerExchange, Response response) {
        httpServerExchange.setStatusCode(302);
        Server.headers().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> httpServerExchange.getResponseHeaders().add(((Header)((Object)((Object)((Object)entry.getKey())))).toHttpString(), (String)entry.getValue()));
        httpServerExchange.getResponseHeaders().put(Header.LOCATION.toHttpString(), response.getRedirectTo());
        response.getHeaders().forEach((httpString, string) -> httpServerExchange.getResponseHeaders().add(httpString, string));
        httpServerExchange.endExchange();
    }

    protected void handleRenderedResponse(HttpServerExchange httpServerExchange, Response response) {
        httpServerExchange.setStatusCode(response.getStatusCode());
        Server.headers().entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> httpServerExchange.getResponseHeaders().add(((Header)((Object)((Object)((Object)entry.getKey())))).toHttpString(), (String)entry.getValue()));
        httpServerExchange.getResponseHeaders().put(Header.CONTENT_TYPE.toHttpString(), response.getContentType() + "; charset=" + response.getCharset());
        response.getHeaders().forEach((httpString, string) -> httpServerExchange.getResponseHeaders().add(httpString, string));
        httpServerExchange.getResponseSender().send(response.getBody());
    }
}

