/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.handlers;

import io.mangoo.core.Application;
import io.mangoo.enums.Header;
import io.mangoo.enums.Required;
import io.mangoo.routing.listeners.WebSocketCloseListener;
import io.mangoo.services.WebSocketService;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.RequestUtils;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.util.Objects;
import org.xnio.ChannelListener;

public class WebSocketHandler
implements WebSocketConnectionCallback {
    private boolean hasAuthentication;
    private Class<?> controllerClass;

    public WebSocketHandler withAuthentication(boolean bl) {
        this.hasAuthentication = bl;
        return this;
    }

    public WebSocketHandler withControllerClass(Class<?> clazz) {
        this.controllerClass = Objects.requireNonNull(clazz, Required.CONTROLLER_CLASS.toString());
        return this;
    }

    public void onConnect(WebSocketHttpExchange webSocketHttpExchange, WebSocketChannel webSocketChannel) {
        if (this.hasAuthentication) {
            String string = null;
            if (webSocketHttpExchange.getRequestHeader(Header.COOKIE.toString()) != null) {
                string = webSocketHttpExchange.getRequestHeader(Header.COOKIE.toString());
            }
            if (RequestUtils.hasValidAuthentication(string)) {
                webSocketChannel.getReceiveSetter().set((ChannelListener)Application.getInstance(this.controllerClass));
                webSocketChannel.resumeReceives();
                webSocketChannel.addCloseTask((ChannelListener)Application.getInstance(WebSocketCloseListener.class));
                Application.getInstance(WebSocketService.class).addChannel(webSocketChannel);
            } else {
                MangooUtils.closeQuietly((Closeable)webSocketChannel);
            }
        } else {
            webSocketChannel.getReceiveSetter().set((ChannelListener)Application.getInstance(this.controllerClass));
            webSocketChannel.resumeReceives();
            webSocketChannel.addCloseTask((ChannelListener)Application.getInstance(WebSocketCloseListener.class));
            Application.getInstance(WebSocketService.class).addChannel(webSocketChannel);
        }
    }
}

