/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.routes;

import io.mangoo.enums.Http;
import io.mangoo.enums.Required;
import io.mangoo.interfaces.MangooRoute;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RequestRoute
implements MangooRoute {
    private Class<?> controllerClass;
    private Http[] methods = new Http[0];
    private Http method;
    private String url;
    private String controllerMethod;
    private String username;
    private String password;
    private int limit;
    private boolean blocking;
    private boolean authentication;
    private boolean authorization;

    public RequestRoute(Http http) {
        Objects.requireNonNull(http, Required.HTTP_METHOD.toString());
        this.method = http;
    }

    public RequestRoute(Http ... httpArray) {
        Objects.requireNonNull(httpArray, Required.HTTP_METHOD.toString());
        this.methods = Arrays.copyOf(httpArray, httpArray.length);
    }

    public RequestRoute to(String object) {
        Objects.requireNonNull(object, Required.URL.toString());
        if ('/' != ((String)object).charAt(0)) {
            object = "/" + (String)object;
        }
        this.url = object;
        return this;
    }

    public RequestRoute respondeWith(String string) {
        Objects.requireNonNull(string, Required.CONTROLLER_METHOD.toString());
        this.controllerMethod = string;
        return this;
    }

    public RequestRoute withRequestLimit(int n) {
        this.limit = n;
        return this;
    }

    public void withControllerClass(Class<?> clazz) {
        Objects.requireNonNull(clazz, Required.CONTROLLER_CLASS.toString());
        this.controllerClass = clazz;
    }

    public void withHttpMethod(Http http) {
        Objects.requireNonNull(http, Required.METHOD.toString());
        this.method = http;
    }

    public RequestRoute withBasicAuthentication(String string, String string2) {
        Objects.requireNonNull(string, Required.USERNAME.toString());
        Objects.requireNonNull(string2, Required.PASSWORD.toString());
        this.username = string;
        this.password = string2;
        return this;
    }

    public RequestRoute withAuthentication() {
        this.authentication = true;
        return this;
    }

    public RequestRoute withAuthorization() {
        this.authentication = true;
        this.authorization = true;
        return this;
    }

    public RequestRoute withNonBlocking() {
        this.blocking = true;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public boolean hasAuthentication() {
        return this.authentication;
    }

    public boolean hasAuthorization() {
        return this.authorization;
    }

    public boolean hasBasicAuthentication() {
        return StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean hasMultipleMethods() {
        return this.methods != null && this.methods.length > 0;
    }

    public Http[] getMethods() {
        return Arrays.copyOf(this.methods, this.methods.length);
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public String getControllerMethod() {
        return this.controllerMethod;
    }

    public int getLimit() {
        return this.limit;
    }

    public Http getMethod() {
        return this.method;
    }

    public boolean isBlocking() {
        return this.blocking;
    }
}

