/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.scheduler;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.Default;
import io.mangoo.enums.Required;
import io.mangoo.exceptions.MangooSchedulerException;
import io.mangoo.models.Job;
import io.mangoo.scheduler.SchedulerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;

@Singleton
public class Scheduler {
    private static final Logger LOG = LogManager.getLogger(Scheduler.class);
    private org.quartz.Scheduler quartzScheduler;

    @Inject
    public Scheduler(Config config) {
        config.getAllConfigurations().entrySet().forEach(entry -> {
            if (((String)entry.getKey()).startsWith(Default.SCHEDULER_PREFIX.toString())) {
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        });
    }

    public void initialize() {
        try {
            this.quartzScheduler = new StdSchedulerFactory().getScheduler();
            this.quartzScheduler.setJobFactory((JobFactory)Application.getInstance(SchedulerFactory.class));
        }
        catch (SchedulerException schedulerException) {
            LOG.error("Failed to initialize scheduler", (Throwable)schedulerException);
        }
    }

    public boolean isInitialize() {
        return this.quartzScheduler != null;
    }

    public boolean isStarted() throws MangooSchedulerException {
        boolean bl;
        try {
            bl = this.quartzScheduler != null && this.quartzScheduler.isStarted();
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
        return bl;
    }

    public org.quartz.Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    public void start() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        try {
            this.quartzScheduler.start();
            if (this.quartzScheduler.isStarted()) {
                LOG.info("Successfully started quartz scheduler");
            } else {
                LOG.error("Scheduler is not started");
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
    }

    public void shutdown() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        try {
            if (this.isStarted()) {
                this.quartzScheduler.shutdown();
                if (this.quartzScheduler.isShutdown()) {
                    LOG.info("Successfully shutdown quartz scheduler");
                } else {
                    LOG.error("Failed to shutdown scheduler");
                }
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
    }

    public void standby() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        try {
            this.quartzScheduler.standby();
            if (this.quartzScheduler.isInStandbyMode()) {
                LOG.info("Scheduler is now in standby");
            } else {
                LOG.error("Failed to put scheduler in standby");
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
    }

    public void schedule(JobDetail jobDetail, Trigger trigger) throws MangooSchedulerException {
        Objects.requireNonNull(jobDetail, Required.JOB_DETAIL.toString());
        Objects.requireNonNull(trigger, Required.TRIGGER.toString());
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        try {
            this.quartzScheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
    }

    public List<Job> getAllJobs() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        ArrayList<Job> arrayList = new ArrayList<Job>();
        try {
            for (JobKey jobKey : this.getAllJobKeys()) {
                List list = this.quartzScheduler.getTriggersOfJob(jobKey);
                Trigger trigger = (Trigger)list.get(0);
                Trigger.TriggerState triggerState = this.quartzScheduler.getTriggerState(trigger.getKey());
                boolean bl = Trigger.TriggerState.NORMAL == triggerState;
                arrayList.add(new Job(bl, jobKey.getName(), trigger.getDescription(), trigger.getNextFireTime(), trigger.getPreviousFireTime()));
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
        return arrayList;
    }

    public void pauseJob(String string) throws MangooSchedulerException {
        Objects.requireNonNull(string, Required.NAME.toString());
        try {
            JobKey jobKey = this.getJobKey(string);
            this.quartzScheduler.pauseJob(jobKey);
        }
        catch (MangooSchedulerException | SchedulerException throwable) {
            throw new MangooSchedulerException((Exception)throwable);
        }
    }

    public void resumeJob(String string) throws MangooSchedulerException {
        Objects.requireNonNull(string, Required.NAME.toString());
        try {
            JobKey jobKey = this.getJobKey(string);
            this.quartzScheduler.resumeJob(jobKey);
        }
        catch (MangooSchedulerException | SchedulerException throwable) {
            throw new MangooSchedulerException((Exception)throwable);
        }
    }

    public void deleteJob(String string) throws MangooSchedulerException {
        Objects.requireNonNull(string, Required.NAME.toString());
        try {
            JobKey jobKey = this.getJobKey(string);
            this.quartzScheduler.deleteJob(jobKey);
        }
        catch (MangooSchedulerException | SchedulerException throwable) {
            throw new MangooSchedulerException((Exception)throwable);
        }
    }

    public JobKey getJobKey(String string) throws MangooSchedulerException {
        Objects.requireNonNull(string, Required.NAME.toString());
        return this.getAllJobKeys().stream().filter(jobKey -> jobKey.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public void executeJob(String string) throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        Objects.requireNonNull(string, Required.JOB_NAME.toString());
        try {
            for (JobKey jobKey : this.getAllJobKeys()) {
                if (!jobKey.getName().equalsIgnoreCase(string)) continue;
                this.quartzScheduler.triggerJob(jobKey);
            }
        }
        catch (MangooSchedulerException | SchedulerException throwable) {
            throw new MangooSchedulerException((Exception)throwable);
        }
    }

    public List<JobKey> getAllJobKeys() throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        ArrayList<JobKey> arrayList = new ArrayList<JobKey>();
        try {
            for (String string : this.quartzScheduler.getJobGroupNames()) {
                arrayList.addAll(this.quartzScheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)string)));
            }
        }
        catch (SchedulerException schedulerException) {
            throw new MangooSchedulerException((Exception)((Object)schedulerException));
        }
        return arrayList;
    }

    public void changeState(String string) throws MangooSchedulerException {
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        try {
            for (JobKey jobKey : this.getAllJobKeys()) {
                if (!jobKey.getName().equalsIgnoreCase(string)) continue;
                Trigger.TriggerState triggerState = this.getTriggerState(jobKey);
                if (Trigger.TriggerState.NORMAL == triggerState) {
                    this.quartzScheduler.pauseJob(jobKey);
                    continue;
                }
                this.quartzScheduler.resumeJob(jobKey);
            }
        }
        catch (MangooSchedulerException | SchedulerException throwable) {
            throw new MangooSchedulerException((Exception)throwable);
        }
    }

    private Trigger.TriggerState getTriggerState(JobKey jobKey) throws SchedulerException {
        Objects.requireNonNull(this.quartzScheduler, Required.SCHEDULER.toString());
        List list = this.quartzScheduler.getTriggersOfJob(jobKey);
        Trigger trigger = (Trigger)list.get(0);
        return this.quartzScheduler.getTriggerState(trigger.getKey());
    }
}

