/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.services;

import com.google.common.io.Resources;
import com.google.inject.Singleton;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.mangoo.enums.Default;
import io.mangoo.interfaces.MangooAuthorizationService;
import io.mangoo.utils.MangooUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Helper;
import org.casbin.jcasbin.util.Util;

@Singleton
public class AuthorizationService
implements MangooAuthorizationService {
    private static final Logger LOG = LogManager.getLogger(AuthorizationService.class);
    private Enforcer enforcer;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", "URLCONNECTION_SSRF_FD"})
    public AuthorizationService() {
        Util.enableLog = false;
        if (MangooUtils.resourceExists(Default.MODEL_CONF.toString()) && MangooUtils.resourceExists(Default.POLICY_CSV.toString())) {
            Model model = new Model();
            try {
                model.loadModelFromText(IOUtils.toString((InputStream)Resources.getResource((String)Default.MODEL_CONF.toString()).openStream(), (String)Default.ENCODING.toString()));
                this.enforcer = new Enforcer(model, (Adapter)new AuthorizationAdapter());
                this.enforcer.enableLog(false);
            }
            catch (IOException iOException) {
                LOG.error("Failed to load model configuration for authorization handling", (Throwable)iOException);
            }
        } else {
            this.enforcer = new Enforcer();
            this.enforcer.enableLog(false);
        }
    }

    @Override
    public boolean validAuthorization(String string, String string2, String string3) {
        return this.enforcer.enforce(new Object[]{string, string2, string3});
    }

    @SuppressFBWarnings(justification="Intenionally used to access the file system", value={"URLCONNECTION_SSRF_FD"})
    private static class AuthorizationAdapter
    implements Adapter {
        private AuthorizationAdapter() {
        }

        public void loadPolicy(Model model) {
            this.loadPolicyFile(model, (Helper.loadPolicyLineHandler<String, Model>)((Helper.loadPolicyLineHandler)Helper::loadPolicyLine));
        }

        private void loadPolicyFile(Model model, Helper.loadPolicyLineHandler<String, Model> loadPolicyLineHandler2) {
            try {
                IOUtils.readLines((InputStream)Resources.getResource((String)Default.POLICY_CSV.toString()).openStream(), (String)Default.ENCODING.toString()).forEach(string -> loadPolicyLineHandler2.accept(string, (Object)model));
            }
            catch (IOException iOException) {
                LOG.error("Failed to load policy configuration for authorization handling", (Throwable)iOException);
            }
        }

        public void savePolicy(Model model) {
        }

        public void addPolicy(String string, String string2, List<String> list) {
        }

        public void removePolicy(String string, String string2, List<String> list) {
        }

        public void removeFilteredPolicy(String string, String string2, int n, String ... stringArray) {
        }
    }
}

