/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.core.Config;
import io.mangoo.enums.Required;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Singleton
public class ConcurrentService {
    private final ExecutorService executorService;

    @Inject
    public ConcurrentService(Config config) {
        Objects.requireNonNull(config, Required.CONFIG.toString());
        this.executorService = Executors.newFixedThreadPool(config.getApplicationThreadpool());
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return this.executorService.submit(callable);
    }

    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.executorService.submit(runnable, t);
    }

    public void execute(Runnable runnable) {
        this.executorService.execute(runnable);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

