/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.services;

import com.google.common.eventbus.AsyncEventBus;
import com.google.inject.Singleton;
import io.mangoo.enums.Required;
import io.mangoo.exceptions.MangooEventBusException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

@Singleton
public class EventBusService {
    private AsyncEventBus asyncEventBus;
    private AtomicLong listeners = new AtomicLong();
    private AtomicLong events = new AtomicLong();

    public EventBusService() {
        this.asyncEventBus = new AsyncEventBus((Executor)Executors.newCachedThreadPool());
    }

    public void register(Object object) {
        Objects.requireNonNull(object, Required.EVENT_LISTENER.toString());
        this.asyncEventBus.register(object);
        this.listeners.getAndIncrement();
    }

    public void unregister(Object object) throws MangooEventBusException {
        Objects.requireNonNull(object, Required.EVENT_LISTENER.toString());
        try {
            this.asyncEventBus.unregister(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MangooEventBusException(illegalArgumentException);
        }
        if (this.listeners.get() > 0L) {
            this.listeners.getAndDecrement();
        }
    }

    public void publish(Object object) {
        Objects.requireNonNull(object, Required.EVENT.toString());
        this.asyncEventBus.post(object);
        this.events.getAndIncrement();
    }

    public long getNumListeners() {
        return this.listeners.get();
    }

    public long getNumEvents() {
        return this.events.get();
    }
}

