/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.services;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.cache.Cache;
import io.mangoo.cache.CacheProvider;
import io.mangoo.enums.CacheName;
import io.mangoo.enums.Default;
import io.mangoo.enums.Required;
import io.mangoo.utils.MangooUtils;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@Singleton
public class ServerSentEventService {
    private final Cache cache;

    @Inject
    private ServerSentEventService(CacheProvider cacheProvider) {
        Objects.requireNonNull(cacheProvider, Required.CACHE_PROVIDER.toString());
        this.cache = cacheProvider.getCache(CacheName.SSE);
    }

    public void addConnection(ServerSentEventConnection serverSentEventConnection) {
        Objects.requireNonNull(serverSentEventConnection, Required.CONNECTION.toString());
        String string = RequestUtils.getServerSentEventURL(serverSentEventConnection);
        Set<ServerSentEventConnection> set = this.getConnections(string);
        if (set == null) {
            set = new HashSet<ServerSentEventConnection>();
            set.add(serverSentEventConnection);
        } else {
            set.add(serverSentEventConnection);
        }
        this.setConnections(string, set);
    }

    public void send(String string, String string2) {
        Objects.requireNonNull(string, Required.URI.toString());
        Set<ServerSentEventConnection> set = this.getConnections(string);
        if (set != null) {
            set.stream().filter(ServerSentEventConnection::isOpen).forEach(serverSentEventConnection -> serverSentEventConnection.send(string2));
        }
    }

    public void send(String string, String string2, ServerSentEventConnection.EventCallback eventCallback) {
        Objects.requireNonNull(string, Required.URI.toString());
        Objects.requireNonNull(eventCallback, Required.EVENT_CALLBACK.toString());
        Set<ServerSentEventConnection> set = this.getConnections(string);
        if (set != null) {
            set.stream().filter(ServerSentEventConnection::isOpen).forEach(serverSentEventConnection -> serverSentEventConnection.send(string2, eventCallback));
        }
    }

    public void close(String string) {
        Objects.requireNonNull(string, Required.URI.toString());
        Set<ServerSentEventConnection> set = this.getConnections(string);
        if (set != null) {
            set.forEach(serverSentEventConnection -> {
                if (serverSentEventConnection.isOpen()) {
                    MangooUtils.closeQuietly((Closeable)serverSentEventConnection);
                }
            });
            this.removeConnections(string);
        }
    }

    public Set<ServerSentEventConnection> getConnections(String string) {
        Objects.requireNonNull(string, Required.URI.toString());
        Set set = (Set)this.cache.get(Default.SSE_CACHE_PREFIX.toString() + string);
        return set == null ? new HashSet() : set;
    }

    public void setConnections(String string, Set<ServerSentEventConnection> set) {
        Objects.requireNonNull(string, Required.URI.toString());
        Objects.requireNonNull(set, Required.URI_CONNECTIONS.toString());
        this.cache.put(Default.SSE_CACHE_PREFIX.toString() + string, set);
    }

    public void removeConnections(String string) {
        Objects.requireNonNull(string, Required.URI.toString());
        this.cache.remove(Default.SSE_CACHE_PREFIX.toString() + string);
    }
}

