/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.templating;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.enums.Required;
import io.mangoo.exceptions.MangooTemplateEngineException;
import io.mangoo.models.Source;
import io.mangoo.templating.TemplateContext;
import io.undertow.server.HttpServerExchange;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import no.api.freemarker.java8.Java8ObjectWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TemplateEngine {
    private final Configuration configuration = new Configuration(VERSION);
    private static final String TEMPLATE_SUFFIX = ".ftl";
    private static final String REGEX = "\n";
    private static final int MIN_LINES = 6;
    private static final int MAX_LINES = 8;
    private static final int MAX_CHARS = 65536;
    private static final int ONE_SECOND_MS = 1000;
    private static final int STRONG_SIZE_LIMIT = 20;
    private static final Version VERSION = new Version(2, 3, 30);

    public TemplateEngine() {
        this.configuration.setClassForTemplateLoading(this.getClass(), Default.TEMPLATES_FOLDER.toString());
        this.configuration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        this.configuration.setOutputEncoding(StandardCharsets.UTF_8.name());
        this.configuration.setLocalizedLookup(false);
        this.configuration.setNumberFormat(Default.NUMBER_FORMAT.toString());
        this.configuration.setAPIBuiltinEnabled(true);
        this.configuration.setObjectWrapper((ObjectWrapper)new Java8ObjectWrapper(VERSION));
        this.configuration.setOutputFormat((OutputFormat)HTMLOutputFormat.INSTANCE);
        this.configuration.setRecognizeStandardFileExtensions(false);
        if (Application.inDevMode()) {
            this.configuration.setTemplateUpdateDelayMilliseconds(1000L);
        } else {
            this.configuration.setTemplateUpdateDelayMilliseconds(Integer.MAX_VALUE);
            this.configuration.setCacheStorage((CacheStorage)new MruCacheStorage(20, Integer.MAX_VALUE));
        }
    }

    @SuppressFBWarnings(value={"TEMPLATE_INJECTION_FREEMARKER"})
    public String renderTemplate(TemplateContext templateContext) throws MangooTemplateEngineException {
        Template template;
        try {
            template = this.configuration.getTemplate(templateContext.getTemplatePath());
        }
        catch (IOException iOException) {
            throw new MangooTemplateEngineException("Template not found on path: " + templateContext.getTemplatePath(), iOException);
        }
        StringWriter stringWriter = new StringWriter(65536);
        try {
            template.process(templateContext.getContent(), (Writer)stringWriter);
        }
        catch (TemplateException | IOException throwable) {
            throw new MangooTemplateEngineException("Failed to process template", (Exception)throwable);
        }
        return stringWriter.toString();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "TEMPLATE_INJECTION_FREEMARKER"})
    public String renderException(HttpServerExchange httpServerExchange, Throwable throwable, boolean bl) throws MangooTemplateEngineException {
        Template template;
        Object object;
        StackTraceElement stackTraceElement;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("templateException", bl);
        if (bl) {
            hashMap.put("exceptions", throwable.getMessage().split(REGEX));
        } else {
            stackTraceElement = throwable.getStackTrace()[0];
            object = this.getSourceCodePath(stackTraceElement);
            try {
                template = this.getSources(stackTraceElement.getLineNumber(), (String)object);
            }
            catch (IOException iOException) {
                throw new MangooTemplateEngineException("Failed to get source lines of exception", iOException);
            }
            hashMap.put("sources", template);
            hashMap.put("cause", ExceptionUtils.getMessage((Throwable)throwable));
            hashMap.put("url", httpServerExchange.getRequestURI());
            hashMap.put("method", httpServerExchange.getRequestMethod());
            hashMap.put("line", stackTraceElement.getLineNumber());
            hashMap.put("causeSource", throwable.toString());
            hashMap.put("stackTraces", throwable.getStackTrace());
            hashMap.put("sourceCodePath", StringUtils.substringAfter((String)Paths.get(this.getBaseDirectory(), new String[0]).resolve((String)object).toFile().getPath(), (String)"src/main/java") + " around line " + stackTraceElement.getLineNumber());
        }
        stackTraceElement = new Configuration(VERSION);
        stackTraceElement.setClassForTemplateLoading(this.getClass(), Default.DEFAULT_TEMPLATES_DIR.toString());
        object = new StringWriter();
        try {
            template = stackTraceElement.getTemplate("exception.ftl");
            template.process(hashMap, (Writer)object);
        }
        catch (TemplateException | IOException throwable2) {
            throw new MangooTemplateEngineException("Failed to process template", (Exception)throwable2);
        }
        return object.toString();
    }

    public String getTemplateName(String string) {
        Objects.requireNonNull(string, Required.TEMPLATE_NAME.toString());
        return string.endsWith(TEMPLATE_SUFFIX) ? string : string + TEMPLATE_SUFFIX;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private List<Source> getSources(int n, String string) throws IOException {
        Objects.requireNonNull(string, Required.SOURCE_PATH.toString());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("user.dir")).append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("java");
        ArrayList<Source> arrayList = new ArrayList<Source>();
        Path path = Paths.get(stringBuilder.toString(), new String[0]).resolve(string);
        if (Files.exists(path, new LinkOption[0])) {
            List<String> list = Files.readAllLines(path);
            int n2 = 0;
            for (String string2 : list) {
                if (n2 + 8 > n && n2 - 6 < n) {
                    arrayList.add(new Source(n2 + 1 == n, n2 + 1, string2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    private String getBaseDirectory() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.getProperty("user.dir")).append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("java");
        return stringBuilder.toString();
    }

    private String getSourceCodePath(StackTraceElement stackTraceElement) {
        Objects.requireNonNull(stackTraceElement, Required.STACK_TRACE_ELEMENT.toString());
        String string = stackTraceElement.getClassName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
            return StringUtils.replace((String)string, (String)".", (String)File.separator) + File.separator + stackTraceElement.getFileName();
        }
        return stackTraceElement.getFileName();
    }
}

