/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.templating.methods;

import freemarker.template.SimpleDate;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import io.mangoo.enums.Required;
import io.mangoo.utils.DateUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import no.api.freemarker.java8.time.LocalDateAdapter;
import no.api.freemarker.java8.time.LocalDateTimeAdapter;
import no.api.freemarker.java8.time.TemporalDialerAdapter;
import org.ocpsoft.prettytime.PrettyTime;

public class PrettyTimeMethod
implements TemplateMethodModelEx {
    private static final int NUM_ARGUMENTS = 1;
    private PrettyTime prettyTime;

    public PrettyTimeMethod(Locale locale) {
        Objects.requireNonNull(locale, Required.LOCALE.toString());
        this.prettyTime = new PrettyTime(locale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String exec(List list) throws TemplateModelException {
        String string = null;
        if (list != null && list.size() == 1) {
            Object object = null;
            Object e = list.get(0);
            if (e instanceof TemporalDialerAdapter) {
                TemporalDialerAdapter temporalDialerAdapter = (TemporalDialerAdapter)e;
                object = temporalDialerAdapter.getObject();
            }
            if (object != null) {
                e = object;
            }
            if (e instanceof LocalDateTimeAdapter) {
                Date date = DateUtils.localDateTimeToDate((LocalDateTime)((LocalDateTimeAdapter)e).getObject());
                return this.prettyTime.format(date);
            }
            if (e instanceof LocalDateAdapter) {
                Date date = DateUtils.localDateToDate((LocalDate)((LocalDateAdapter)e).getObject());
                return this.prettyTime.format(date);
            }
            if (e instanceof LocalDateTime) {
                Date date = DateUtils.localDateTimeToDate((LocalDateTime)e);
                return this.prettyTime.format(date);
            }
            if (e instanceof LocalDate) {
                Date date = DateUtils.localDateToDate((LocalDate)e);
                return this.prettyTime.format(date);
            }
            if (e instanceof SimpleDate) {
                Date date = ((SimpleDate)e).getAsDate();
                return this.prettyTime.format(date);
            }
            if (!(e instanceof Date)) throw new TemplateModelException("Invalid object found for prettytime function. Must be of type: SimpleDate, Date, LocalDateTime or LocalDate - Is: " + e.getClass());
            return this.prettyTime.format((Date)e);
        }
        if (list == null) throw new TemplateModelException("Invalid number of arguments passed to prettytime function.");
        if (list.size() <= 1) throw new TemplateModelException("Invalid number of arguments passed to prettytime function.");
        throw new TemplateModelException("Too many arguments for prettytime function. Allowed arguments: 1");
    }
}

